/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.URL;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSequence
implements CharSequence {
    private final URL url;
    private final CharSequence html;
    private final SortedMap<Long, byte[]> encodeError;

    public static void dumpEncodeError(SortedMap<Long, byte[]> sortedMap) {
        if (sortedMap.size() > 0) {
            Set<Long> set = sortedMap.keySet();
            for (long l : set) {
                byte[] byArray;
                System.out.print(" " + l);
                for (byte by : byArray = (byte[])sortedMap.get(l)) {
                    System.out.print(" " + by);
                }
            }
        }
    }

    public HtmlSequence(URL uRL, CharSequence charSequence, SortedMap<Long, byte[]> sortedMap) throws NullPointerException {
        if (uRL == null || charSequence == null || sortedMap == null) {
            throw new NullPointerException();
        }
        this.url = uRL;
        this.html = charSequence;
        this.encodeError = sortedMap;
    }

    public URL getURL() {
        return this.url;
    }

    protected SortedMap<Long, byte[]> getEncodeError() {
        return this.encodeError;
    }

    public SortedMap<Long, byte[]> subEncodeError(long l, long l2) {
        TreeMap<Long, byte[]> treeMap = new TreeMap<Long, byte[]>();
        Set<Long> set = this.encodeError.keySet();
        for (long l3 : set) {
            if (l3 < l) continue;
            if (l2 <= l3) break;
            byte[] byArray = (byte[])this.encodeError.get(l3);
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            treeMap.put(l3 - l, byArray2);
        }
        return treeMap;
    }

    @Override
    public char charAt(int n) {
        return this.html.charAt(n);
    }

    @Override
    public int length() {
        return this.html.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.html.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return ((Object)this.html).toString();
    }
}

