/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.TextPopup;

public class FindPanel
extends JDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u691c\u7d22 - " + Jindolf.TITLE;
    private static final int IGNORECASEFLAG = 66;
    private final JComboBox findBox = new JComboBox();
    private final JButton searchButton = new JButton("\u691c\u7d22");
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JCheckBox capitalSwitch = new JCheckBox("\u5927\u6587\u5b57/\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3059\u308b");
    private final JCheckBox regexSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe");
    private final JCheckBox dotallSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \".\" \u3092\u884c\u672b\u8a18\u53f7\u306b\u3082\u30de\u30c3\u30c1\u3055\u305b\u308b");
    private final JCheckBox multilineSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \"^\" \u3084 \"$\" \u3092\u884c\u672b\u8a18\u53f7\u306e\u524d\u5f8c\u306b\u53cd\u5fdc\u3055\u305b\u308b");
    private final JCheckBox bulkSearchSwitch = new JCheckBox("\u5168\u65e5\u7a0b\u3092\u4e00\u62ec\u691c\u7d22");
    private final JButton closeButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private final CustomModel model = new CustomModel();
    private boolean isCanceled = false;
    private RegexPattern regexPattern = null;

    public FindPanel(Frame frame) {
        super(frame, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FindPanel.this.actionCancel();
            }
        });
        this.design();
        this.findBox.setModel(this.model);
        this.findBox.setToolTipText("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.findBox.setEditable(true);
        this.findBox.setRenderer(new CustomRenderer());
        this.findBox.setMaximumRowCount(15);
        ComboBoxEditor comboBoxEditor = this.findBox.getEditor();
        Component component = comboBoxEditor.getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setComponentPopupMenu(new TextPopup());
        }
        this.searchButton.setToolTipText("\u767a\u8a00\u5185\u5bb9\u3092\u691c\u7d22\u3059\u308b");
        this.clearButton.setToolTipText("\u5165\u529b\u3092\u30af\u30ea\u30a2\u3059\u308b");
        this.findBox.addItemListener(this);
        this.searchButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.regexSwitch.addChangeListener(this);
        this.closeButton.addActionListener(this);
        this.setRegexPattern(null);
    }

    private void design() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.findBox, "Center");
        jPanel.setBorder(titledBorder);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        container.add((Component)this.searchButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.clearButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.capitalSwitch, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.regexSwitch, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(this.dotallSwitch);
        jPanel2.add(this.multilineSwitch);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        container.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        container.add((Component)this.bulkSearchSwitch, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        container.add((Component)this.closeButton, gridBagConstraints);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.getRootPane().setDefaultButton(this.searchButton);
        this.findBox.requestFocusInWindow();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isBulkSearch() {
        return this.bulkSearchSwitch.isSelected();
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void actionSubmit() {
        Object object = this.findBox.getSelectedItem();
        if (object == null) {
            this.regexPattern = null;
            return;
        }
        String string = object.toString();
        boolean bl = this.regexSwitch.isSelected();
        int n = 0;
        if (!this.capitalSwitch.isSelected()) {
            n |= 0x42;
        }
        if (this.dotallSwitch.isSelected()) {
            n |= 0x20;
        }
        if (this.multilineSwitch.isSelected()) {
            n |= 8;
        }
        try {
            this.regexPattern = new RegexPattern(string, bl, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.regexPattern = null;
            if (this.showRegexError(patternSyntaxException)) {
                return;
            }
            this.actionCancel();
            return;
        }
        this.model.addHistory(this.regexPattern);
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private boolean showRegexError(PatternSyntaxException patternSyntaxException) {
        Object[] objectArray;
        Icon icon;
        String string;
        int n;
        String string2 = patternSyntaxException.getPattern();
        String string3 = "";
        int n2 = patternSyntaxException.getIndex();
        if (0 <= n2 && n2 <= string2.length() - 1) {
            char c = string2.charAt(n2);
            string3 = "\u30a8\u30e9\u30fc\u306e\u767a\u751f\u7b87\u6240\u306f\u3001\u304a\u304a\u3088\u305d" + (n2 + 1) + "\u6587\u5b57\u76ee [ " + c + " ] " + "\u304b\u305d\u306e\u524d\u5f8c\u3068\u63a8\u6e2c\u3055\u308c\u307e\u3059\u3002\n";
        }
        if ((n = JOptionPane.showOptionDialog(this, string = "\u5165\u529b\u3055\u308c\u305f\u691c\u7d22\u6587\u5b57\u5217 [ " + string2 + " ] \u306f" + "\u6b63\u3057\u3044\u6b63\u898f\u8868\u73fe\u3068\u3057\u3066\u8a8d\u8b58\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + string3 + "\u6b63\u898f\u8868\u73fe\u306e\u66f8\u304d\u65b9\u306f" + " [ http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/" + "java/util/regex/Pattern.html#sum ] " + "\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n" + "\u305f\u3060\u306e\u6587\u5b57\u5217\u3092\u691c\u7d22\u3057\u305f\u3044\u5834\u5408\u306f" + "\u300c\u6b63\u898f\u8868\u73fe\u300d\u306e\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u3092\u5916\u3057\u307e\u3057\u3087\u3046\u3002\n", "\u4e0d\u6b63\u306a\u6b63\u898f\u8868\u73fe", 0, 0, icon = null, objectArray = new Object[]{"\u518d\u5165\u529b", "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb"}, "\u518d\u5165\u529b")) == -1) {
            return false;
        }
        if (objectArray[n] == "\u518d\u5165\u529b") {
            return true;
        }
        return objectArray[n] != "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb";
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(RegexPattern regexPattern) {
        this.regexPattern = regexPattern == null ? CustomModel.INITITEM : regexPattern;
        String string = this.regexPattern.getEditSource();
        this.findBox.getEditor().setItem(string);
        this.regexSwitch.setSelected(this.regexPattern.isRegex());
        int n = this.regexPattern.getRegexFlag();
        this.capitalSwitch.setSelected((n & 0x42) == 0);
        this.dotallSwitch.setSelected((n & 0x20) != 0);
        this.multilineSwitch.setSelected((n & 8) != 0);
        this.maskRegexUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.actionCancel();
        } else if (object == this.searchButton) {
            this.actionSubmit();
        } else if (object == this.clearButton) {
            this.findBox.getEditor().setItem("");
            this.findBox.requestFocusInWindow();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n != 1) {
            return;
        }
        Object object = itemEvent.getItem();
        if (!(object instanceof RegexPattern)) {
            return;
        }
        RegexPattern regexPattern = (RegexPattern)object;
        this.setRegexPattern(regexPattern);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() != this.regexSwitch) {
            return;
        }
        this.maskRegexUI();
    }

    private void maskRegexUI() {
        boolean bl = this.regexSwitch.isSelected();
        this.dotallSwitch.setEnabled(bl);
        this.multilineSwitch.setEnabled(bl);
    }

    private static class CustomModel
    implements ComboBoxModel {
        private static final int HISTORY_MAX = 7;
        public static final RegexPattern INITITEM = new RegexPattern("", false, 98);
        private static final List<RegexPattern> predefRegex = new LinkedList<RegexPattern>();
        private final LinkedList<RegexPattern> history = new LinkedList();
        private final JSeparator separator1st = new JSeparator();
        private final JSeparator separator2nd = new JSeparator();
        private Object selected;
        private final EventListenerList listenerList = new EventListenerList();

        private CustomModel() {
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object object) {
            if (object instanceof JSeparator) {
                return;
            }
            this.selected = object;
        }

        public Object getElementAt(int n) {
            int n2 = this.history.size();
            if (n == 0) {
                return INITITEM;
            }
            if (n == 1) {
                return this.separator1st;
            }
            if (2 <= n && n <= 1 + n2) {
                return this.history.get(n - 2);
            }
            if (n == n2 + 2) {
                return this.separator2nd;
            }
            if (n2 + 3 <= n) {
                return predefRegex.get(n - 1 - 1 - n2 - 1);
            }
            return null;
        }

        public int getSize() {
            int n = 1;
            ++n;
            n += this.history.size();
            ++n;
            return n += predefRegex.size();
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.listenerList.add(ListDataListener.class, listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.listenerList.remove(ListDataListener.class, listDataListener);
        }

        public void addHistory(RegexPattern regexPattern) {
            if (regexPattern == null) {
                return;
            }
            if (regexPattern.equals(INITITEM)) {
                return;
            }
            if (predefRegex.contains(regexPattern)) {
                return;
            }
            if (this.history.contains(regexPattern)) {
                this.history.remove(regexPattern);
            }
            this.history.add(0, regexPattern);
            while (this.history.size() > 7) {
                this.history.remove(7);
            }
            this.fire();
        }

        private void fire() {
            ListDataListener[] listDataListenerArray;
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            for (ListDataListener listDataListener : listDataListenerArray = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
                listDataListener.contentsChanged(listDataEvent);
            }
        }

        static {
            predefRegex.add(new RegexPattern("\u3010[^\u3011]*\u3011", true, 32, "     \u203b \u91cd\u8981\u4e8b\u9805"));
            predefRegex.add(new RegexPattern("[\u25a0\u25cf\u25bc\u2605\u25a1\u25cb\u25bd\u2606\u3007\u25ef\u2207]", true, 32, "     \u203b \u8b70\u984c"));
            predefRegex.add(new RegexPattern("Jindolf", false, 66, "     \u203b \u5ba3\u4f1d"));
        }
    }

    private static class CustomRenderer
    extends DefaultListCellRenderer {
        private CustomRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JSeparator) {
                return (JSeparator)object;
            }
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof RegexPattern) {
                RegexPattern regexPattern = (RegexPattern)object;
                String string = regexPattern.isRegex() ? "[R]\u3000" + regexPattern.getEditSource() : regexPattern.getEditSource();
                string = string + regexPattern.getComment();
                jLabel.setText(string);
            }
            return jLabel;
        }
    }
}

