/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorHitEvent;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.SysEventDraw;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.TextRow;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discussion
extends JComponent
implements Scrollable,
MouseInputListener,
ComponentListener {
    private Period period;
    private final List<TextRow> rowList = new LinkedList<TextRow>();
    private final List<TalkDraw> talkDrawList = new LinkedList<TalkDraw>();
    private TopicFilter topicFilter;
    private TopicFilter.FilterContext filterContext;
    private RegexPattern regexPattern;
    private Point dragFrom;
    private Font font;
    private FontRenderContext renderContext;
    private final RenderingHints hints = new RenderingHints(null);
    private Dimension idealSize;
    private int lastWidth = -1;
    private final DiscussionPopup popup = new DiscussionPopup();
    private final EventListenerList thisListenerList = new EventListenerList();
    private final Action copySelectedAction = new ProxyAction("COPY");

    public Discussion() {
        this.font = GUIUtils.DEFAULT_FONT;
        this.renderContext = GUIUtils.DEFAULT_FRC;
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.updateRenderingHints();
        this.setPeriod(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.setComponentPopupMenu(this.popup);
        this.updateInputMap();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", this.copySelectedAction);
    }

    private void updateRenderingHints() {
        Object object = this.renderContext.isAntiAliased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        Object object2 = this.renderContext.usesFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, object2);
    }

    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        this.font = font;
        this.renderContext = fontRenderContext;
        this.updateRenderingHints();
        for (TextRow textRow : this.rowList) {
            textRow.setFontInfo(this.font, this.renderContext);
        }
        this.layoutRows();
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        if (period == null) {
            this.period = null;
            this.rowList.clear();
            this.talkDrawList.clear();
            return;
        }
        if (this.period == period && period.getTopics() == this.rowList.size()) {
            this.filterTopics();
            return;
        }
        this.period = period;
        this.filterContext = null;
        this.rowList.clear();
        this.talkDrawList.clear();
        for (Topic topic : this.period.getTopicList()) {
            AbstractTextRow abstractTextRow;
            Topic topic2;
            if (topic instanceof Talk) {
                topic2 = (Talk)topic;
                TalkDraw talkDraw = new TalkDraw((Talk)topic2);
                this.talkDrawList.add(talkDraw);
                abstractTextRow = talkDraw;
            } else if (topic instanceof SysEvent) {
                topic2 = (SysEvent)topic;
                abstractTextRow = new SysEventDraw((SysEvent)topic2);
            } else {
                assert (false);
                continue;
            }
            abstractTextRow.setFontInfo(this.font, this.renderContext);
            this.rowList.add(abstractTextRow);
        }
        this.filterTopics();
        this.clearSizeCache();
        this.layoutRows();
    }

    public void setTopicFilter(TopicFilter topicFilter) {
        this.topicFilter = topicFilter;
        this.filtering();
    }

    public void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
        this.filterTopics();
        this.layoutVertical();
        this.clearSelect();
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public int setRegexPattern(RegexPattern regexPattern) {
        this.regexPattern = regexPattern;
        int n = 0;
        this.clearHotTarget();
        Pattern pattern = null;
        if (this.regexPattern != null) {
            pattern = this.regexPattern.getPattern();
        }
        for (TalkDraw talkDraw : this.talkDrawList) {
            n += talkDraw.setRegex(pattern);
        }
        this.repaint();
        return n;
    }

    public void nextHotTarget() {
        TalkDraw talkDraw = null;
        int n = -1;
        TalkDraw talkDraw2 = null;
        int n2 = -1;
        TalkDraw talkDraw3 = null;
        boolean bl = true;
        for (TalkDraw talkDraw4 : this.talkDrawList) {
            int n3 = talkDraw4.getRegexMatches();
            if (talkDraw3 == null && n3 > 0) {
                talkDraw3 = talkDraw4;
            }
            if (bl) {
                int n4 = talkDraw4.getHotTargetIndex();
                if (n4 < 0) continue;
                talkDraw = talkDraw4;
                n = n4;
                this.scrollRectWithMargin(talkDraw4.getHotTargetRectangle());
                if (n < n3 - 1 && !this.isFiltered(talkDraw4)) {
                    talkDraw2 = talkDraw4;
                    n2 = n + 1;
                    break;
                }
                bl = false;
                continue;
            }
            if (this.isFiltered(talkDraw4) || n3 <= 0) continue;
            talkDraw2 = talkDraw4;
            n2 = 0;
            break;
        }
        Object object = null;
        if (talkDraw == null && talkDraw3 != null) {
            talkDraw3.setHotTargetIndex(0);
            object = talkDraw3.getHotTargetRectangle();
        } else if (talkDraw != null && talkDraw2 != null) {
            talkDraw.clearHotTarget();
            talkDraw2.setHotTargetIndex(n2);
            object = talkDraw2.getHotTargetRectangle();
        }
        if (object != null) {
            this.scrollRectWithMargin((Rectangle)object);
        }
        this.repaint();
    }

    public void prevHotTarget() {
        int n;
        Object object;
        Object object2 = null;
        int n2 = -1;
        Object object3 = null;
        int n3 = -1;
        TalkDraw talkDraw = null;
        boolean bl = true;
        int n4 = this.talkDrawList.size();
        ListIterator<TalkDraw> listIterator = this.talkDrawList.listIterator(n4);
        while (listIterator.hasPrevious()) {
            object = listIterator.previous();
            n = ((TalkDraw)object).getRegexMatches();
            if (talkDraw == null && n > 0) {
                talkDraw = object;
            }
            if (bl) {
                int n5 = ((TalkDraw)object).getHotTargetIndex();
                if (n5 < 0) continue;
                object2 = object;
                n2 = n5;
                this.scrollRectWithMargin(((TalkDraw)object).getHotTargetRectangle());
                if (n2 > 0 && !this.isFiltered((TextRow)object)) {
                    object3 = object;
                    n3 = n2 - 1;
                    break;
                }
                bl = false;
                continue;
            }
            if (this.isFiltered((TextRow)object) || n <= 0) continue;
            object3 = object;
            n3 = n - 1;
            break;
        }
        object = null;
        if (object2 == null && talkDraw != null) {
            n = talkDraw.getRegexMatches();
            talkDraw.setHotTargetIndex(n - 1);
            object = talkDraw.getHotTargetRectangle();
        } else if (object2 != null && object3 != null) {
            ((TalkDraw)object2).clearHotTarget();
            ((TalkDraw)object3).setHotTargetIndex(n3);
            object = ((TalkDraw)object3).getHotTargetRectangle();
        }
        if (object != null) {
            this.scrollRectWithMargin((Rectangle)object);
        }
        this.repaint();
    }

    public void clearHotTarget() {
        for (TalkDraw talkDraw : this.talkDrawList) {
            talkDraw.clearHotTarget();
        }
        this.repaint();
    }

    private void scrollRectWithMargin(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.y -= 50;
        rectangle2.height += 150;
        this.scrollRectToVisible(rectangle2);
    }

    private void clearSizeCache() {
        this.idealSize = null;
        this.lastWidth = -1;
        this.revalidate();
    }

    private boolean isFiltered(TextRow textRow) {
        Topic topic;
        if (this.topicFilter == null) {
            return false;
        }
        if (textRow instanceof TalkDraw) {
            topic = ((TalkDraw)textRow).getTalk();
        } else if (textRow instanceof SysEventDraw) {
            topic = ((SysEventDraw)textRow).getSysEvent();
        } else {
            return false;
        }
        return this.topicFilter.isFiltered(topic);
    }

    private void filterTopics() {
        for (TextRow textRow : this.rowList) {
            if (this.isFiltered(textRow)) {
                textRow.setVisible(false);
                continue;
            }
            textRow.setVisible(true);
        }
    }

    private void setWidth(int n) {
        this.lastWidth = n;
        Insets insets = this.getInsets();
        n -= insets.left + insets.right;
        for (TextRow textRow : this.rowList) {
            textRow.setWidth(n);
        }
        this.layoutVertical();
    }

    private void layoutVertical() {
        Rectangle rectangle = null;
        Insets insets = this.getInsets();
        int n = insets.top;
        for (TextRow textRow : this.rowList) {
            if (!textRow.isVisible()) continue;
            textRow.setPos(insets.left, n);
            Rectangle rectangle2 = textRow.getBounds();
            n += rectangle2.height;
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2);
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle == null) {
            rectangle = new Rectangle(insets.left, insets.top, 0, 0);
        }
        if (this.idealSize == null) {
            this.idealSize = new Dimension();
        }
        int n2 = insets.left + rectangle.width + insets.right;
        int n3 = insets.top + rectangle.height + insets.bottom;
        this.idealSize.setSize(n2, n3);
        this.setPreferredSize(this.idealSize);
        this.revalidate();
        this.repaint();
    }

    public void layoutRows() {
        int n = this.getWidth();
        this.setWidth(n);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.hints);
        graphics2D.setColor(Color.BLACK);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (TextRow textRow : this.rowList) {
            Rectangle rectangle2;
            if (!textRow.isVisible() || !(rectangle2 = textRow.getBounds()).intersects(rectangle)) continue;
            textRow.paint(graphics2D);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return 30;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    public Rectangle getTalkBounds(Talk talk) {
        if (this.topicFilter != null && this.topicFilter.isFiltered(talk)) {
            return null;
        }
        for (TalkDraw talkDraw : this.talkDrawList) {
            if (talkDraw.getTalk() != talk) continue;
            Rectangle rectangle = talkDraw.getBounds();
            return rectangle;
        }
        return null;
    }

    private void drag(Point point, Point point2) {
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(point, point2);
        for (TextRow textRow : this.rowList) {
            if (this.isFiltered(textRow) || !textRow.getBounds().intersects(rectangle)) continue;
            textRow.drag(point, point2);
        }
        this.repaint();
    }

    private void clearSelect() {
        for (TextRow textRow : this.rowList) {
            textRow.clearSelect();
        }
        this.repaint();
    }

    private TalkDraw getHittedTalkDraw(Point point) {
        for (TalkDraw talkDraw : this.talkDrawList) {
            Rectangle rectangle;
            if (this.isFiltered(talkDraw) || !(rectangle = talkDraw.getBounds()).contains(point)) continue;
            return talkDraw;
        }
        return null;
    }

    private void hitAnchor(Point point) {
        TalkDraw talkDraw = this.getHittedTalkDraw(point);
        if (talkDraw == null) {
            return;
        }
        Anchor anchor = talkDraw.getAnchor(point);
        if (anchor == null) {
            return;
        }
        for (AnchorHitListener anchorHitListener : this.getAnchorHitListeners()) {
            AnchorHitEvent anchorHitEvent = new AnchorHitEvent(this, talkDraw, anchor, point);
            anchorHitListener.anchorHitted(anchorHitEvent);
        }
    }

    private void hitRegex(Point point) {
        TalkDraw talkDraw = this.getHittedTalkDraw(point);
        if (talkDraw == null) {
            return;
        }
        int n = talkDraw.getRegexMatchIndex(point);
        if (n < 0) {
            return;
        }
        this.clearHotTarget();
        talkDraw.setHotTargetIndex(n);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getButton() == 1) {
            this.clearSelect();
            this.hitAnchor(point);
            this.hitRegex(point);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (mouseEvent.getButton() == 1) {
            this.clearSelect();
            this.dragFrom = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.dragFrom = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragFrom == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        this.drag(this.dragFrom, point);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.lastWidth) {
            this.setWidth(n);
        }
        if (this.idealSize.width != n || this.idealSize.height != n2) {
            this.revalidate();
        }
    }

    public CharSequence getSelected() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TextRow textRow : this.rowList) {
            if (this.isFiltered(textRow)) continue;
            try {
                textRow.appendSelected(stringBuilder);
            }
            catch (IOException iOException) {
                assert (false);
                return null;
            }
        }
        if (stringBuilder.length() <= 0) {
            return null;
        }
        return stringBuilder;
    }

    public CharSequence copySelected() {
        CharSequence charSequence = this.getSelected();
        if (charSequence == null) {
            return null;
        }
        ClipboardAction.copyToClipBoard(charSequence);
        return charSequence;
    }

    public CharSequence copyTalk() {
        TalkDraw talkDraw = this.popup.lastPopupedTalkDraw;
        if (talkDraw == null) {
            return null;
        }
        Talk talk = talkDraw.getTalk();
        StringBuilder stringBuilder = new StringBuilder();
        Avatar avatar = talk.getAvatar();
        stringBuilder.append(avatar.getName()).append(' ');
        String string = talk.getAnchorNotation();
        stringBuilder.append(string).append('\n');
        stringBuilder.append(talk.getDialog());
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
            stringBuilder.append('\n');
        }
        ClipboardAction.copyToClipBoard(stringBuilder);
        return stringBuilder;
    }

    public Talk getPopupedTalk() {
        TalkDraw talkDraw = this.popup.lastPopupedTalkDraw;
        if (talkDraw == null) {
            return null;
        }
        Talk talk = talkDraw.getTalk();
        return talk;
    }

    public Anchor getPopupedAnchor() {
        return this.popup.lastPopupedAnchor;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.popup.updateUI();
        this.updateInputMap();
    }

    private void updateInputMap() {
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap();
        InputMap inputMap2 = new JTextField().getInputMap();
        for (KeyStroke keyStroke : keyStrokeArray = inputMap2.allKeys()) {
            Object object = inputMap2.get(keyStroke);
            if (!object.equals("copy-to-clipboard")) continue;
            inputMap.put(keyStroke, "copy-to-clipboard");
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.thisListenerList.add(ActionListener.class, actionListener);
        this.popup.menuCopy.addActionListener(actionListener);
        this.popup.menuSelTalk.addActionListener(actionListener);
        this.popup.menuJumpAnchor.addActionListener(actionListener);
        this.popup.menuWebTalk.addActionListener(actionListener);
        this.popup.menuSummary.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.thisListenerList.remove(ActionListener.class, actionListener);
        this.popup.menuCopy.removeActionListener(actionListener);
        this.popup.menuSelTalk.removeActionListener(actionListener);
        this.popup.menuJumpAnchor.removeActionListener(actionListener);
        this.popup.menuWebTalk.removeActionListener(actionListener);
        this.popup.menuSummary.removeActionListener(actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.thisListenerList.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener anchorHitListener) {
        this.thisListenerList.add(AnchorHitListener.class, anchorHitListener);
    }

    public void removeAnchorHitListener(AnchorHitListener anchorHitListener) {
        this.thisListenerList.remove(AnchorHitListener.class, anchorHitListener);
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.thisListenerList.getListeners(AnchorHitListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray = this.thisListenerList.getListeners(clazz);
        if (eventListenerArray.length <= 0) {
            eventListenerArray = super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    private class DiscussionPopup
    extends JPopupMenu {
        private final JMenuItem menuCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuSelTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuJumpAnchor = new JMenuItem("\u30a2\u30f3\u30ab\u30fc\u306e\u793a\u3059\u5148\u3078\u30b8\u30e3\u30f3\u30d7");
        private final JMenuItem menuWebTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...");
        private final JMenuItem menuSummary = new JMenuItem("\u767a\u8a00\u3092\u96c6\u8a08...");
        private TalkDraw lastPopupedTalkDraw;
        private Anchor lastPopupedAnchor;

        public DiscussionPopup() {
            this.add(this.menuCopy);
            this.add(this.menuSelTalk);
            this.addSeparator();
            this.add(this.menuJumpAnchor);
            this.add(this.menuWebTalk);
            this.addSeparator();
            this.add(this.menuSummary);
            this.menuCopy.setActionCommand("COPY");
            this.menuSelTalk.setActionCommand("COPYTALK");
            this.menuJumpAnchor.setActionCommand("JUMPANCHOR");
            this.menuWebTalk.setActionCommand("WEBTALK");
            this.menuSummary.setActionCommand("DAYSUMMARY");
            this.menuWebTalk.setIcon(GUIUtils.getWWWIcon());
        }

        public void show(Component component, int n, int n2) {
            Point point = new Point(n, n2);
            this.lastPopupedTalkDraw = Discussion.this.getHittedTalkDraw(point);
            if (this.lastPopupedTalkDraw != null) {
                this.menuSelTalk.setEnabled(true);
                this.menuWebTalk.setEnabled(true);
            } else {
                this.menuSelTalk.setEnabled(false);
                this.menuWebTalk.setEnabled(false);
            }
            this.lastPopupedAnchor = this.lastPopupedTalkDraw != null ? this.lastPopupedTalkDraw.getAnchor(point) : null;
            if (this.lastPopupedAnchor != null) {
                this.menuJumpAnchor.setEnabled(true);
            } else {
                this.menuJumpAnchor.setEnabled(false);
            }
            if (Discussion.this.getSelected() != null) {
                this.menuCopy.setEnabled(true);
            } else {
                this.menuCopy.setEnabled(false);
            }
            super.show(component, n, n2);
        }
    }

    private class ProxyAction
    extends AbstractAction {
        private final String command;

        public ProxyAction(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException();
            }
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = actionEvent.getID();
            String string = this.command;
            long l = actionEvent.getWhen();
            int n2 = actionEvent.getModifiers();
            for (ActionListener actionListener : Discussion.this.getActionListeners()) {
                ActionEvent actionEvent2 = new ActionEvent(object, n, string, l, n2);
                actionListener.actionPerformed(actionEvent2);
            }
        }
    }
}

