/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avatar
implements Comparable<Avatar> {
    private static final String AVATAR_DEF = "resources/avatar.properties";
    private static final String KEY_PREFIX = "avatar.serialNo.";
    private static final SortedSet<Avatar> predefinedAvatarSet = Avatar.loadPredefSet();
    private static final Map<String, Avatar> avatarMap = new TreeMap<String, Avatar>();
    private final String name;
    private final String jobTitle;
    private final String fullName;
    private final int idNum;
    private final String identifier;

    private static SortedSet<Avatar> loadPredefSet() {
        InputStream inputStream = Jindolf.getResourceAsStream(AVATAR_DEF);
        return Avatar.loadPredefSet(inputStream);
    }

    private static SortedSet<Avatar> loadPredefSet(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            assert (false);
            throw new Error();
        }
        return Avatar.loadPredefSet(properties);
    }

    private static SortedSet<Avatar> loadPredefSet(Properties properties) {
        Integer n;
        String string;
        String string2;
        String string3 = properties.getProperty("codeCheck");
        if (string3 == null || string3.length() != 1 || string3.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u30ad\u30e3\u30e9\u30af\u30bf\u5b9a\u7fa9\u4e00\u89a7\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            throw new Error();
        }
        Set<Object> set = properties.keySet();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (Object iterator : set) {
            String string4;
            if (iterator == null || !(string4 = iterator.toString()).startsWith(KEY_PREFIX)) continue;
            string2 = properties.getProperty(string4);
            string = string4.replace(KEY_PREFIX, "");
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException string5) {
                continue;
            }
            treeMap.put(string2, n);
        }
        SortedSet<Avatar> sortedSet = new TreeSet();
        for (String string4 : treeMap.keySet()) {
            string2 = string4 + ".name";
            string = string4 + ".job";
            n = (Integer)treeMap.get(string4);
            String string5 = properties.getProperty(string2);
            String string6 = properties.getProperty(string);
            Avatar avatar = new Avatar(string5, string6, n, string4);
            sortedSet.add(avatar);
        }
        sortedSet = Collections.unmodifiableSortedSet(sortedSet);
        return sortedSet;
    }

    public static SortedSet<Avatar> getPredefinedAvatarSet() {
        return predefinedAvatarSet;
    }

    public static Avatar getPredefinedAvatar(String string) {
        return avatarMap.get(string);
    }

    private Avatar(String string, String string2, int n, String string3) {
        this.name = string.intern();
        this.jobTitle = string2.intern();
        this.idNum = n;
        this.identifier = string3.intern();
        this.fullName = (this.jobTitle + " " + this.name).intern();
    }

    public Avatar(String string) {
        this.fullName = string.intern();
        this.idNum = -1;
        String[] stringArray = this.fullName.split("\\p{Blank}+", 2);
        if (stringArray.length == 1) {
            this.jobTitle = null;
            this.name = this.fullName;
        } else if (stringArray.length == 2) {
            this.jobTitle = stringArray[0].intern();
            this.name = stringArray[1].intern();
        } else {
            this.jobTitle = null;
            this.name = null;
            assert (false);
        }
        this.identifier = "???".intern();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Avatar)) {
            return false;
        }
        Avatar avatar = (Avatar)object;
        boolean bl2 = this.fullName.equals(avatar.fullName);
        boolean bl3 = bl = this.idNum == avatar.idNum;
        return bl2 && bl;
    }

    public int hashCode() {
        return this.fullName.hashCode() ^ this.idNum;
    }

    @Override
    public int compareTo(Avatar avatar) {
        if (avatar == null) {
            return 1;
        }
        return this.idNum - avatar.idNum;
    }

    static {
        for (Avatar avatar : predefinedAvatarSet) {
            String string = avatar.getFullName();
            avatarMap.put(string, avatar);
        }
    }
}

