/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Village;

public class AnchorDraw
extends AbstractTextRow {
    private static final Color COLOR_ANCHOR = new Color(0xFFFF99);
    private static final int UNDER_MARGIN = 5;
    private final Talk talk;
    private final GlyphDraw caption;
    private final GlyphDraw dialog;
    private final Image faceImage;
    private final Point imageOrigin = new Point();
    private final Point captionOrigin = new Point();
    private final Point dialogOrigin = new Point();

    public AnchorDraw(Talk talk) {
        this.talk = talk;
        Period period = this.talk.getPeriod();
        Village village = period.getVillage();
        Avatar avatar = this.talk.getAvatar();
        Image image = this.talk.getTalkType() == Talk.Type.GRAVE ? village.getGraveImage() : village.getAvatarFaceImage(avatar);
        this.faceImage = image;
        this.caption = new GlyphDraw(this.getCaptionString());
        this.dialog = new GlyphDraw(this.talk.getDialog());
        this.caption.setFontInfo(this.font, this.renderContext);
        this.dialog.setFontInfo(this.font, this.renderContext);
        this.caption.setColor(COLOR_ANCHOR);
        this.dialog.setColor(COLOR_ANCHOR);
    }

    private CharSequence getCaptionString() {
        StringBuilder stringBuilder = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        stringBuilder.append(avatar.getFullName()).append(' ').append(this.talk.getAnchorNotation());
        return stringBuilder;
    }

    public Rectangle setWidth(int n) {
        int n2;
        int n3;
        int n4 = this.faceImage.getWidth(null);
        int n5 = this.faceImage.getHeight(null);
        this.caption.setWidth(n - n4);
        int n6 = this.caption.getWidth();
        int n7 = this.caption.getHeight();
        this.dialog.setWidth(n);
        int n8 = this.dialog.getWidth();
        int n9 = this.dialog.getHeight();
        int n10 = Math.max(n5, n7);
        int n11 = Math.max(n4 + n6, n8);
        int n12 = n10;
        n12 += n9;
        if (n5 > n7) {
            n3 = 0;
            n2 = (n5 - n7) / 2;
        } else {
            n3 = (n7 - n5) / 2;
            n2 = 0;
        }
        this.imageOrigin.setLocation(0, n3);
        this.captionOrigin.setLocation(n4, n2);
        this.dialogOrigin.setLocation(0, n10);
        this.bounds.width = n11;
        this.bounds.height = n12 + 5;
        return this.bounds;
    }

    public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
        super.setFontInfo(font, fontRenderContext);
        this.caption.setFontInfo(this.font, this.renderContext);
        this.dialog.setFontInfo(this.font, this.renderContext);
        int n = this.getWidth();
        this.setWidth(n);
    }

    public void drag(Point point, Point point2) {
        this.caption.drag(point, point2);
        this.dialog.drag(point, point2);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
    }

    public int setRegex(Pattern pattern) {
        int n = 0;
        return n += this.dialog.setRegex(pattern);
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        graphics2D.drawImage(this.faceImage, n + this.imageOrigin.x, n2 + this.imageOrigin.y, null);
        this.caption.setPos(n + this.captionOrigin.x, n2 + this.captionOrigin.y);
        this.caption.paint(graphics2D);
        this.dialog.setPos(n + this.dialogOrigin.x, n2 + this.dialogOrigin.y);
        this.dialog.paint(graphics2D);
    }
}

