/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;

public class ActionManager {
    public static final String CMD_ACCOUNT = "ACCOUNT";
    public static final String CMD_EXIT = "EXIT";
    public static final String CMD_COPY = "COPY";
    public static final String CMD_SHOWFIND = "SHOWFIND";
    public static final String CMD_SEARCHNEXT = "SEARCHNEXT";
    public static final String CMD_SEARCHPREV = "SEARCHPREV";
    public static final String CMD_ALLPERIOD = "ALLPERIOD";
    public static final String CMD_WEBVILL = "WEBVILL";
    public static final String CMD_WEBCAST = "WEBCAST";
    public static final String CMD_WEBWIKI = "WEBWIKI";
    public static final String CMD_RELOAD = "RELOAD";
    public static final String CMD_DAYSUMMARY = "DAYSUMMARY";
    public static final String CMD_DAYEXPCSV = "DAYEXPCSV";
    public static final String CMD_WEBDAY = "WEBDAY";
    public static final String CMD_FONTSEL = "FONTSELECT";
    public static final String CMD_LANDF = "LANDF";
    public static final String CMD_SHOWFILT = "SHOWFILT";
    public static final String CMD_SHOWEDIT = "SHOWEDIT";
    public static final String CMD_SHOWLOG = "SHOWLOG";
    public static final String CMD_HELPDOC = "HELPDOC";
    public static final String CMD_SHOWPORTAL = "SHOWPORTAL";
    public static final String CMD_ABOUT = "ABOUT";
    public static final String CMD_COPYTALK = "COPYTALK";
    public static final String CMD_JUMPANCHOR = "JUMPANCHOR";
    public static final String CMD_WEBTALK = "WEBTALK";
    public static final String CMD_SWITCHORDER = "SWITCHORDER";
    public static final String CMD_VILLAGELIST = "VILLAGELIST";
    public static final String CMD_FONTSIZESEL = "FONTSIZESEL";
    public static final String CMD_FONTAPPLY = "FONTAPPLY";
    public static final String CMD_FONTCANCEL = "FONTCANCEL";
    public static final KeyStroke keyF1 = KeyStroke.getKeyStroke("F1");
    public static final KeyStroke keyF3 = KeyStroke.getKeyStroke("F3");
    public static final KeyStroke keyShiftF3 = KeyStroke.getKeyStroke("shift F3");
    public static final KeyStroke keyF5 = KeyStroke.getKeyStroke("F5");
    public static final KeyStroke keyCtrlF = KeyStroke.getKeyStroke("ctrl F");
    public static final Icon wwwIcon = GUIUtils.getWWWIcon();
    public static final Icon findIcon;
    public static final Icon searchPrevIcon;
    public static final Icon searchNextIcon;
    public static final Icon reloadIcon;
    private final Set<AbstractButton> actionItems = new HashSet<AbstractButton>();
    private final Map<String, JMenuItem> namedMenuItems = new HashMap<String, JMenuItem>();
    private final Map<String, AbstractButton> namedToolButtons = new HashMap<String, AbstractButton>();
    private final JMenuBar menuBar;
    private final JMenu menuFile;
    private final JMenu menuEdit;
    private final JMenu menuVillage;
    private final JMenu menuDay;
    private final JMenu menuPreference;
    private final JMenu menuTool;
    private final JMenu menuHelp;
    private final JMenu menuLook;
    private final ButtonGroup landfGroup = new ButtonGroup();
    private final Map<ButtonModel, String> landfMap = new HashMap<ButtonModel, String>();
    private final JToolBar browseToolBar;

    public ActionManager() {
        this.menuFile = this.buildMenu("\u30d5\u30a1\u30a4\u30eb", 70);
        this.menuEdit = this.buildMenu("\u7de8\u96c6", 69);
        this.menuVillage = this.buildMenu("\u6751", 86);
        this.menuDay = this.buildMenu("\u65e5", 68);
        this.menuPreference = this.buildMenu("\u8a2d\u5b9a", 80);
        this.menuTool = this.buildMenu("\u30c4\u30fc\u30eb", 84);
        this.menuHelp = this.buildMenu("\u30d8\u30eb\u30d7", 72);
        this.menuLook = this.buildLookAndFeelMenu("\u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb", 76);
        this.buildMenuItem(CMD_ACCOUNT, "\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406", 77);
        this.buildMenuItem(CMD_EXIT, "\u7d42\u4e86", 88);
        this.buildMenuItem(CMD_COPY, "\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc", 67);
        this.buildMenuItem(CMD_SHOWFIND, "\u691c\u7d22...", 70);
        this.buildMenuItem(CMD_SEARCHNEXT, "\u6b21\u5019\u88dc", 78);
        this.buildMenuItem(CMD_SEARCHPREV, "\u524d\u5019\u88dc", 80);
        this.buildMenuItem(CMD_ALLPERIOD, "\u5168\u65e5\u7a0b\u306e\u4e00\u62ec\u8aad\u307f\u8fbc\u307f", 82);
        this.buildMenuItem(CMD_WEBVILL, "\u3053\u306e\u6751\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...", 78);
        this.buildMenuItem(CMD_WEBWIKI, "\u307e\u3068\u3081\u30b5\u30a4\u30c8\u3092\u8868\u793a...", 77);
        this.buildMenuItem(CMD_WEBCAST, "\u30ad\u30e3\u30b9\u30c8\u7d39\u4ecb\u8868\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf...", 72);
        this.buildMenuItem(CMD_RELOAD, "\u3053\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9", 82);
        this.buildMenuItem(CMD_DAYSUMMARY, "\u3053\u306e\u65e5\u306e\u767a\u8a00\u3092\u96c6\u8a08...", 68);
        this.buildMenuItem(CMD_DAYEXPCSV, "CSV\u3078\u30a8\u30af\u30b9\u30dd\u30fc\u30c8...", 67);
        this.buildMenuItem(CMD_WEBDAY, "\u3053\u306e\u65e5\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...", 66);
        this.buildMenuItem(CMD_FONTSEL, "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u9078\u629e...", 70);
        this.buildMenuItem(CMD_SHOWFILT, "\u767a\u8a00\u30d5\u30a3\u30eb\u30bf", 70);
        this.buildMenuItem(CMD_SHOWEDIT, "\u767a\u8a00\u30a8\u30c7\u30a3\u30bf", 69);
        this.buildMenuItem(CMD_SHOWLOG, "\u30ed\u30b0\u8868\u793a", 83);
        this.buildMenuItem(CMD_HELPDOC, "\u30d8\u30eb\u30d7\u8868\u793a", 72);
        this.buildMenuItem(CMD_SHOWPORTAL, "\u30dd\u30fc\u30bf\u30eb\u30b5\u30a4\u30c8...", 80);
        this.buildMenuItem(CMD_ABOUT, Jindolf.TITLE + "\u306b\u3064\u3044\u3066...", 65);
        this.buildToolButton(CMD_RELOAD, "\u9078\u629e\u4e2d\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9", reloadIcon);
        this.buildToolButton(CMD_SHOWFIND, "\u691c\u7d22", findIcon);
        this.buildToolButton(CMD_SEARCHPREV, "\u2191\u524d\u5019\u88dc", searchPrevIcon);
        this.buildToolButton(CMD_SEARCHNEXT, "\u2193\u6b21\u5019\u88dc", searchNextIcon);
        this.getMenuItem(CMD_SHOWPORTAL).setIcon(wwwIcon);
        this.getMenuItem(CMD_WEBVILL).setIcon(wwwIcon);
        this.getMenuItem(CMD_WEBWIKI).setIcon(wwwIcon);
        this.getMenuItem(CMD_WEBCAST).setIcon(wwwIcon);
        this.getMenuItem(CMD_WEBDAY).setIcon(wwwIcon);
        this.getMenuItem(CMD_SHOWFIND).setIcon(findIcon);
        this.getMenuItem(CMD_SEARCHPREV).setIcon(searchPrevIcon);
        this.getMenuItem(CMD_SEARCHNEXT).setIcon(searchNextIcon);
        this.registKeyAccelerator();
        this.menuBar = this.buildMenuBar();
        this.browseToolBar = this.buildBrowseToolBar();
        this.appearVillage(false);
        this.appearPeriod(false);
    }

    private JMenu buildMenu(String string, int n) {
        JMenu jMenu = new JMenu();
        String string2 = "(" + KeyEvent.getKeyText(n) + ")";
        string = string + string2;
        jMenu.setText(string);
        jMenu.setMnemonic(n);
        return jMenu;
    }

    private JMenuItem buildMenuItem(String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem();
        String string3 = "(" + KeyEvent.getKeyText(n) + ")";
        string2 = string2 + string3;
        jMenuItem.setActionCommand(string);
        jMenuItem.setText(string2);
        jMenuItem.setMnemonic(n);
        this.actionItems.add(jMenuItem);
        this.namedMenuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    private JButton buildToolButton(String string, String string2, Icon icon) {
        JButton jButton = new JButton();
        jButton.setIcon(icon);
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setActionCommand(string);
        this.actionItems.add(jButton);
        this.namedToolButtons.put(string, jButton);
        return jButton;
    }

    private JMenu buildLookAndFeelMenu(String string, int n) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        JMenu jMenu = this.buildMenu(string, n);
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string2 = lookAndFeel.getClass().getName();
        AbstractButton abstractButton = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            String string3 = lookAndFeelInfo.getName();
            String string4 = lookAndFeelInfo.getClassName();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string3);
            jRadioButtonMenuItem.setActionCommand(CMD_LANDF);
            if (string4.equals(string2)) {
                abstractButton = jRadioButtonMenuItem;
            }
            this.actionItems.add(jRadioButtonMenuItem);
            this.landfGroup.add(jRadioButtonMenuItem);
            this.landfMap.put(jRadioButtonMenuItem.getModel(), string4);
            jMenu.add(jRadioButtonMenuItem);
        }
        if (abstractButton != null) {
            abstractButton.setSelected(true);
        }
        return jMenu;
    }

    private void registKeyAccelerator() {
        this.getMenuItem(CMD_HELPDOC).setAccelerator(keyF1);
        this.getMenuItem(CMD_SHOWFIND).setAccelerator(keyCtrlF);
        this.getMenuItem(CMD_SEARCHNEXT).setAccelerator(keyF3);
        this.getMenuItem(CMD_SEARCHPREV).setAccelerator(keyShiftF3);
        this.getMenuItem(CMD_RELOAD).setAccelerator(keyF5);
    }

    private JMenuItem getMenuItem(String string) {
        JMenuItem jMenuItem = this.namedMenuItems.get(string);
        return jMenuItem;
    }

    private AbstractButton getToolButton(String string) {
        AbstractButton abstractButton = this.namedToolButtons.get(string);
        return abstractButton;
    }

    public String getSelectedLookAndFeel() {
        ButtonModel buttonModel = this.landfGroup.getSelection();
        if (buttonModel == null) {
            return null;
        }
        String string = this.landfMap.get(buttonModel);
        return string;
    }

    public void addActionListener(ActionListener actionListener) {
        for (AbstractButton abstractButton : this.actionItems) {
            abstractButton.addActionListener(actionListener);
        }
    }

    private JMenuBar buildMenuBar() {
        this.menuFile.add(this.getMenuItem(CMD_ACCOUNT));
        this.menuFile.addSeparator();
        this.menuFile.add(this.getMenuItem(CMD_EXIT));
        this.menuEdit.add(this.getMenuItem(CMD_COPY));
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.getMenuItem(CMD_SHOWFIND));
        this.menuEdit.add(this.getMenuItem(CMD_SEARCHPREV));
        this.menuEdit.add(this.getMenuItem(CMD_SEARCHNEXT));
        this.menuVillage.add(this.getMenuItem(CMD_ALLPERIOD));
        this.menuVillage.addSeparator();
        this.menuVillage.add(this.getMenuItem(CMD_WEBVILL));
        this.menuVillage.add(this.getMenuItem(CMD_WEBWIKI));
        this.menuVillage.add(this.getMenuItem(CMD_WEBCAST));
        this.menuDay.add(this.getMenuItem(CMD_RELOAD));
        this.menuDay.add(this.getMenuItem(CMD_DAYSUMMARY));
        this.menuDay.add(this.getMenuItem(CMD_DAYEXPCSV));
        this.menuDay.addSeparator();
        this.menuDay.add(this.getMenuItem(CMD_WEBDAY));
        this.menuPreference.add(this.getMenuItem(CMD_FONTSEL));
        this.menuPreference.addSeparator();
        this.menuPreference.add(this.menuLook);
        this.menuTool.add(this.getMenuItem(CMD_SHOWFILT));
        this.menuTool.add(this.getMenuItem(CMD_SHOWEDIT));
        this.menuTool.add(this.getMenuItem(CMD_SHOWLOG));
        this.menuHelp.add(this.getMenuItem(CMD_HELPDOC));
        this.menuHelp.addSeparator();
        this.menuHelp.add(this.getMenuItem(CMD_SHOWPORTAL));
        this.menuHelp.add(this.getMenuItem(CMD_ABOUT));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.menuFile);
        jMenuBar.add(this.menuEdit);
        jMenuBar.add(this.menuVillage);
        jMenuBar.add(this.menuDay);
        jMenuBar.add(this.menuPreference);
        jMenuBar.add(this.menuTool);
        jMenuBar.add(this.menuHelp);
        return jMenuBar;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private JToolBar buildBrowseToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.getToolButton(CMD_RELOAD));
        jToolBar.addSeparator();
        jToolBar.add(this.getToolButton(CMD_SHOWFIND));
        jToolBar.add(this.getToolButton(CMD_SEARCHNEXT));
        jToolBar.add(this.getToolButton(CMD_SEARCHPREV));
        return jToolBar;
    }

    public JToolBar getBrowseToolBar() {
        return this.browseToolBar;
    }

    public void appearPeriod(boolean bl) {
        if (bl) {
            this.appearVillage(bl);
        }
        this.menuEdit.setEnabled(bl);
        this.menuDay.setEnabled(bl);
        this.getToolButton(CMD_RELOAD).setEnabled(bl);
        this.getToolButton(CMD_SHOWFIND).setEnabled(bl);
        this.getToolButton(CMD_SEARCHNEXT).setEnabled(bl);
        this.getToolButton(CMD_SEARCHPREV).setEnabled(bl);
    }

    public void appearVillage(boolean bl) {
        if (!bl) {
            this.appearPeriod(bl);
        }
        this.menuVillage.setEnabled(bl);
    }

    static {
        URL uRL = Jindolf.getResource("resources/image/find.png");
        findIcon = new ImageIcon(uRL);
        uRL = Jindolf.getResource("resources/image/findprev.png");
        searchPrevIcon = new ImageIcon(uRL);
        uRL = Jindolf.getResource("resources/image/findnext.png");
        searchNextIcon = new ImageIcon(uRL);
        uRL = Jindolf.getResource("resources/image/reload.png");
        reloadIcon = new ImageIcon(uRL);
    }
}

