/*
 * URI expoter
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: UriExporter.java 366 2009-01-23 13:18:15Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/**
 * URIのエクスポートを行う。
 * エクスポートに使うMIMEは「text/uri-list」と「text/plain」。
 */
public class UriExporter implements Transferable{

    private static final String[] mimes = {
        "text/uri-list",
        "text/plain",
    };
    private static final List<DataFlavor> uriFlavors
            = new ArrayList<DataFlavor>(mimes.length);

    static{
        String stringClassName = "class=" + String.class.getName();
        for(String mime : mimes){
            mime += "; " + stringClassName;
            DataFlavor dataFlavor;
            try{
                dataFlavor = new DataFlavor(mime);
            }catch(ClassNotFoundException e){
                assert false;
                throw new ExceptionInInitializerError(e);
            }
            uriFlavors.add(dataFlavor);
        }
    }

    private URI uri;

    /**
     * コンストラクタ
     * @param uri URI
     */
    public UriExporter(URI uri){
        super();
        this.uri = uri;
        return;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public DataFlavor[] getTransferDataFlavors(){
        DataFlavor[] result = new DataFlavor[uriFlavors.size()];
        int index = 0;
        for(DataFlavor dataFlavor : uriFlavors){
            try{
                result[index++] = (DataFlavor)( dataFlavor.clone() );
            }catch(CloneNotSupportedException e){
                assert false;
                return null;
            }
        }
        return result;
    }

    /**
     * {@inheritDoc}
     * @param flavor {@inheritDoc}
     * @return {@inheritDoc}
     */
    public boolean isDataFlavorSupported(DataFlavor flavor){
        for(DataFlavor dataFlavor : uriFlavors){
            if(dataFlavor.equals(flavor)) return true;
        }
        return false;
    }

    /**
     * {@inheritDoc}
     * エクスポートするURI文字列を返す。
     * @param flavor {@inheritDoc}
     * @return {@inheritDoc}
     * @throws java.awt.datatransfer.UnsupportedFlavorException {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    public Object getTransferData(DataFlavor flavor)
            throws UnsupportedFlavorException,
                   IOException {
        if( ! isDataFlavorSupported(flavor) ){
            throw new UnsupportedFlavorException(flavor);
        }

        String result = this.uri.toASCIIString();

        return result;
    }
}
