/*
 * Village icon renderer for JTree
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: VillageIconRenderer.java 375 2009-01-31 16:25:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * JTreeの村別アイコン表示
 */
@SuppressWarnings("serial")
public class VillageIconRenderer extends DefaultTreeCellRenderer{

    private static final ImageIcon prologueIcon;
    private static final ImageIcon progressIcon;
    private static final ImageIcon epilogueIcon;
    private static final ImageIcon gameoverIcon;
    private static final ImageIcon invalidIcon;

    static{
        URL url;
        url = Jindolf.getResource("resources/image/prologue.png");
        prologueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/progress.png");
        progressIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/epilogue.png");
        epilogueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/gameover.png");
        gameoverIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/cross.png");
        invalidIcon = new ImageIcon(url);
    }

    /**
     * {@inheritDoc}
     * 村種別によってツリーリストアイコンを書き分ける。
     * @param tree {@inheritDoc}
     * @param value {@inheritDoc}
     * @param sel {@inheritDoc}
     * @param expanded {@inheritDoc}
     * @param leaf {@inheritDoc}
     * @param row {@inheritDoc}
     * @param hasFocus {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public Component getTreeCellRendererComponent(
            JTree tree,
            Object value,
            boolean sel,
            boolean expanded,
            boolean leaf,
            int row,
            boolean hasFocus ){
        if(leaf && value instanceof Village){
            Village village = (Village) value;
            ImageIcon icon = null;
            switch(village.getState()){
            case PROLOGUE: icon = prologueIcon; break;
            case PROGRESS: icon = progressIcon; break;
            case EPILOGUE: icon = epilogueIcon; break;
            case GAMEOVER: icon = gameoverIcon; break;
            default: assert false; break;
            }
            if( ! village.isValid()) icon = invalidIcon;
            setLeafIcon(icon);
        }

        Component comp =
                super
                .getTreeCellRendererComponent(
                    tree,
                    value,
                    sel,
                    expanded,
                    leaf,
                    row,
                    hasFocus
                );

        return comp;
    }
}
