/*
 * 矩形領域テキスト描画抽象クラス
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: AbstractTextRow.java 308 2008-11-29 15:54:21Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;

/**
 * TextRowの実装を助けるクラス。
 */
public abstract class AbstractTextRow implements TextRow{

    protected final Rectangle bounds = new Rectangle();
    protected Font font                       = GUIUtils.DEFAULT_FONT;
    protected FontRenderContext renderContext = GUIUtils.DEFAULT_FRC;

    private boolean isVisible = true;

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public Rectangle getBounds(){
        return this.bounds;
    }

    /**
     * {@inheritDoc}
     * @param xPos {@inheritDoc}
     * @param yPos {@inheritDoc}
     */
    public void setPos(int xPos, int yPos){
        this.bounds.x = xPos;
        this.bounds.y = yPos;
        return;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public int getWidth(){
        return this.bounds.width;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public int getHeight(){
        return this.bounds.height;
    }

    /**
     * {@inheritDoc}
     * @param font {@inheritDoc}
     * @param renderContext {@inheritDoc}
     */
    public void setFontInfo(Font font, FontRenderContext renderContext){
        this.font = font;
        this.renderContext = renderContext;
        return;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public boolean isVisible(){
        return this.isVisible;
    }

    /**
     * {@inheritDoc}
     * @param visible {@inheritDoc}
     */
    public void setVisible(boolean visible){
        this.isVisible = visible;
        return;
    }
}
