/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Topic;

public class SysEvent
implements Topic {
    private static Pattern murderRegex = Pattern.compile("\u6b21\u306e\u65e5\u306e\u671d\u3001(.+) \u304c\u7121\u6b8b\u306a\u59ff\u3067\u767a\u898b\u3055\u308c\u305f\u3002\\n", 32);
    private static Pattern nomurderRegex = Pattern.compile("\u4eca\u65e5\u306f\u72a0\u7272\u8005\u304c\u3044\u306a\u3044\u3088\u3046\u3060\u3002\u4eba\u72fc\u306f\u8972\u6483\u306b\u5931\u6557\u3057\u305f\u306e\u3060\u308d\u3046\u304b\u3002\\n", 32);
    private EventClass eventClass;
    private String message;
    private Type type = Type.UNKNOWN;

    public static EventClass decodeEventClass(CharSequence eventClass) {
        EventClass result;
        if ("announce".contentEquals(eventClass)) {
            result = EventClass.ANNOUNCE;
        } else if ("order".contentEquals(eventClass)) {
            result = EventClass.ORDER;
        } else if ("extra".contentEquals(eventClass)) {
            result = EventClass.EXTRA;
        } else {
            assert (false);
            return null;
        }
        return result;
    }

    public static CharSequence encodeEventClass(EventClass eventClass) {
        String result;
        switch (eventClass) {
            case ANNOUNCE: {
                result = "announce";
                break;
            }
            case ORDER: {
                result = "order";
                break;
            }
            case EXTRA: {
                result = "extra";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public SysEvent(EventClass eventClass, String message) throws NullPointerException {
        if (eventClass == null || message == null) {
            throw new NullPointerException();
        }
        this.eventClass = eventClass;
        this.message = message.replace("<br />", "\n").replace("&gt;", ">").replace("&lt;", "<").replace("&nbsp;", " ").replace("&quot;", "\"").replace("&amp;", "&").replaceAll("<a [^>]*>", "").replace("</a>", "");
        Matcher matcher = murderRegex.matcher(this.message);
        if (matcher.matches()) {
            this.type = Type.MURDER;
            return;
        }
        matcher = nomurderRegex.matcher(this.message);
        if (matcher.matches()) {
            this.type = Type.NOMURDER;
            return;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STARTPROLOGUE,
        ONSTAGE,
        WINVILLAGE,
        WINWOLF,
        WINHAMSTER,
        MURDER,
        NOMURDER,
        GAMEOVER,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventClass {
        ANNOUNCE,
        ORDER,
        EXTRA;

    }
}

