/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import jp.sourceforge.jindolf.AccountCookie;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Village;

public class ServerAccess {
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String ENCODING_HTML = "Shift_JIS";
    private static final Charset CHARSET_SJIS = Charset.forName("Shift_JIS");
    private static final int BUF_SIZE = 1024;
    private static final String JINRO_CGI = "./index.rb";
    private final URL baseURL;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;
    private AccountCookie cookieAuth = null;
    private String encodedUserID = null;

    public static String formEncode(String formData) {
        String result;
        if (formData == null) {
            return null;
        }
        try {
            result = URLEncoder.encode(formData, ENCODING_HTML);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            result = null;
        }
        return result;
    }

    public static String formEncode(char[] formData) {
        return ServerAccess.formEncode(new String(formData));
    }

    public static CharSequence downloadHTMLStream(InputStream is) throws IOException {
        int chs;
        StringBuilder result = new StringBuilder();
        Reader reader = new InputStreamReader(is, CHARSET_SJIS);
        reader = new BufferedReader(reader, 1024);
        char[] buffer = new char[1024];
        while ((chs = reader.read(buffer)) > 0) {
            result.append(buffer, 0, chs);
        }
        reader.close();
        return result;
    }

    public ServerAccess(URL baseURL) {
        this.baseURL = baseURL;
    }

    protected URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getCGIURL() {
        URL result;
        try {
            result = new URL(this.baseURL, JINRO_CGI);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    protected URL getQueryURL(CharSequence query) {
        URL result;
        if (query.length() >= 1 && query.charAt(0) != '?') {
            return null;
        }
        try {
            result = new URL(this.getCGIURL(), ((Object)query).toString());
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    private HttpURLConnection setupConnection(CharSequence query, String method) throws IOException {
        URL url = this.getQueryURL(query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestProperty("Accept", "*/*");
        httpConnection.setRequestProperty("User-Agent", USER_AGENT);
        httpConnection.setUseCaches(false);
        httpConnection.setInstanceFollowRedirects(false);
        httpConnection.setDoInput(true);
        if (method.equalsIgnoreCase("GET")) {
            httpConnection.setRequestMethod("GET");
            AccountCookie cookie = this.cookieAuth;
            if (cookie != null) {
                if (ServerAccess.shouldAccept(url, cookie)) {
                    httpConnection.setRequestProperty("Cookie", "login=" + cookie.getLoginData());
                } else {
                    this.clearAuthentication();
                }
            }
        } else if (method.equalsIgnoreCase("POST")) {
            httpConnection.setRequestMethod("POST");
            httpConnection.setDoOutput(true);
        } else {
            assert (false);
            return null;
        }
        return httpConnection;
    }

    protected InputStream getHTMLStream(CharSequence query) throws IOException {
        HttpURLConnection connection = this.setupConnection(query, "GET");
        String method = connection.getRequestMethod();
        URL url = connection.getURL();
        Jindolf.logger.info(method + " " + url);
        connection.connect();
        this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        Date connDate = new Date(connection.getDate());
        Jindolf.logger.info(responseCode + " " + responseMessage + " " + connDate);
        if (responseCode != 200) {
            return null;
        }
        String charset = HttpUtils.getHTMLCharset(connection);
        if (!charset.equalsIgnoreCase(ENCODING_HTML)) {
            return null;
        }
        InputStream stream = connection.getInputStream();
        return stream;
    }

    protected CharSequence downloadHTML(CharSequence query) throws IOException {
        InputStream stream = this.getHTMLStream(query);
        if (stream == null) {
            return null;
        }
        return ServerAccess.downloadHTMLStream(stream);
    }

    public CharSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public CharSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public CharSequence getHTMLBoneHead(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID + "&meslog=");
    }

    public CharSequence getHTMLVillage(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID);
    }

    public CharSequence getHTMLPeriod(Period period) throws IOException {
        return this.downloadHTML(period.getCGIQuery());
    }

    public void updateLastAccess(HttpURLConnection connection) {
        this.lastServerMs = connection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
    }

    protected boolean postAuthData(String authData) throws IOException {
        byte[] authBytes = authData.getBytes();
        HttpURLConnection connection = this.setupConnection("", "POST");
        String method = connection.getRequestMethod();
        URL url = connection.getURL();
        Jindolf.logger.info(method + " " + url);
        OutputStream os = connection.getOutputStream();
        os.write(authBytes);
        os.flush();
        os.close();
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        Date connDate = new Date(connection.getDate());
        Jindolf.logger.info(responseCode + " " + responseMessage + " " + connDate);
        if (responseCode != 302) {
            return false;
        }
        this.updateLastAccess(connection);
        AccountCookie loginCookie = AccountCookie.createCookie(connection);
        if (loginCookie == null) {
            return false;
        }
        this.setAuthentication(loginCookie);
        return true;
    }

    private static boolean shouldAccept(URL url, AccountCookie cookie) {
        String cookiePath;
        if (cookie.hasExpired()) {
            return false;
        }
        String urlPath = url.getPath();
        return urlPath.startsWith(cookiePath = cookie.getPathURI().getPath());
    }

    public boolean hasLoggedIn() {
        AccountCookie cookie = this.cookieAuth;
        if (cookie == null) {
            return false;
        }
        if (cookie.hasExpired()) {
            this.clearAuthentication();
            return false;
        }
        return true;
    }

    public final boolean login(String userID, char[] password) throws IOException {
        boolean result;
        if (this.hasLoggedIn()) {
            return true;
        }
        String id = ServerAccess.formEncode(userID);
        if (id == null || id.length() <= 0) {
            return false;
        }
        String pw = ServerAccess.formEncode(password);
        if (pw == null || pw.length() <= 0) {
            return false;
        }
        this.encodedUserID = id;
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=login");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(id);
        postData.append('&').append("password=").append(pw);
        try {
            result = this.postAuthData(postData.toString());
        }
        catch (IOException e) {
            this.clearAuthentication();
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IOException {
        if (!this.hasLoggedIn()) {
            return;
        }
        if (this.encodedUserID == null) {
            this.clearAuthentication();
            return;
        }
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=logout");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(this.encodedUserID);
        try {
            this.postAuthData(postData.toString());
        }
        finally {
            this.clearAuthentication();
        }
    }

    protected void clearAuthentication() {
        this.cookieAuth = null;
        this.encodedUserID = null;
    }

    private void setAuthentication(AccountCookie cookie) {
        this.cookieAuth = cookie;
    }
}

