/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexPattern {
    private static final String REGEX_ITEM_PREFIX = "[R] ";
    private final String editSource;
    private final boolean isRegex;
    private final Pattern pattern;
    private final int flag;
    private final String comment;

    public RegexPattern(String editSource, boolean isRegex, int flag, String comment) throws PatternSyntaxException {
        this.editSource = editSource;
        this.isRegex = isRegex;
        this.flag = flag;
        this.comment = comment;
        String regexExpr = this.isRegex ? this.editSource : Pattern.quote(this.editSource);
        this.pattern = Pattern.compile(regexExpr, this.flag);
    }

    public RegexPattern(String editSource, boolean isRegex, int flag) throws PatternSyntaxException {
        this(editSource, isRegex, flag, "");
    }

    public String getEditSource() {
        return this.editSource;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public int getFlag() {
        return this.flag;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getListItemString() {
        String result = this.isRegex() ? REGEX_ITEM_PREFIX + this.getEditSource() : this.getEditSource();
        result = result + this.comment;
        return result;
    }

    public String toString() {
        return this.getListItemString();
    }
}

