/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Jindolf;

public class HttpUtils {
    private static String tokenRegex = "([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)";
    private static String mtypeRegex = "[\\p{Blank}]*" + tokenRegex + "/" + tokenRegex + "[\\p{Blank}]*";
    private static String paramRegex = "[\\p{Blank}]*;[\\p{Blank}]*" + tokenRegex + "[\\p{Blank}]*=[\\p{Blank}]*" + "(" + tokenRegex + "|" + "(\"[^\\p{Cntrl}\\\"]*\")" + ")";
    private static Pattern mtypePattern = Pattern.compile(mtypeRegex);
    private static Pattern attrPattern = Pattern.compile(paramRegex);

    public static String getUserAgentName() {
        String comment;
        StringBuilder result = new StringBuilder();
        result.append(Jindolf.TITLE).append("/").append("2.11.2");
        StringBuilder rawComment = new StringBuilder();
        if (AppSetting.osName != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(AppSetting.osName);
        }
        if (AppSetting.osVersion != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(AppSetting.osVersion);
        }
        if (AppSetting.osArch != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(AppSetting.osArch);
        }
        if (AppSetting.javaVendor != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(AppSetting.javaVendor);
        }
        if (AppSetting.javaVersion != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(AppSetting.javaVersion);
        }
        if ((comment = HttpUtils.escapeHttpComment(rawComment)) != null) {
            result.append(" ").append((CharSequence)comment);
        }
        return result.toString();
    }

    public static String escapeHttpComment(CharSequence comment) {
        if (comment == null) {
            return null;
        }
        if (comment.length() <= 0) {
            return null;
        }
        String result = ((Object)comment).toString();
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        result = result.replaceAll("[\\u0000-\\u001f]", "?");
        result = result.replaceAll("[\\u007f-\\uffff]", "?");
        result = "(" + result + ")";
        return result;
    }

    public static String getHTMLCharset(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            return null;
        }
        return HttpUtils.getHTMLCharset(contentType);
    }

    public static String getHTMLCharset(String contentType) {
        Matcher matcher = mtypePattern.matcher(contentType);
        boolean matchResult = matcher.lookingAt();
        if (!matchResult) {
            return null;
        }
        int lastPos = matcher.end();
        String type = matcher.group(1);
        String subtype = matcher.group(2);
        if (!type.equalsIgnoreCase("text")) {
            return null;
        }
        if (!subtype.equalsIgnoreCase("html")) {
            return null;
        }
        matcher.usePattern(attrPattern);
        String charset = null;
        while (matchResult = matcher.find(lastPos)) {
            lastPos = matcher.end();
            String attribute = matcher.group(1);
            String value = matcher.group(2);
            if (!attribute.equalsIgnoreCase("charset")) continue;
            charset = value;
        }
        return charset;
    }

    private HttpUtils() {
        assert (false);
        throw new Error();
    }
}

