/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingConstants;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.SequenceCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphDraw
implements RowsLtoR,
SwingConstants {
    private static final Color COLOR_SELECTION = new Color(12111845);
    private static final Color COLOR_SEARCHHIT = new Color(11711232);
    private static final Color COLOR_HOTTARGET = Color.ORANGE;
    private Font font;
    private FontRenderContext frc;
    private Color foregroundColor = Color.WHITE;
    private final CharSequence source;
    private final Rectangle bounds = new Rectangle();
    private float[] dimArray;
    private final List<GlyphVector> lines = new LinkedList<GlyphVector>();
    private Collection<Anchor> anchorSet;
    private final List<MatchInfo> matchList = new LinkedList<MatchInfo>();
    private MatchInfo hotTarget = null;
    private int selectStart = -1;
    private int selectLast = -1;

    public GlyphDraw(Font font, FontRenderContext frc, CharSequence source) {
        this.font = font;
        this.frc = frc;
        this.source = source;
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(this.source);
        GlyphVector gv = this.font.createGlyphVector(this.frc, iterator);
        int sourceLength = gv.getNumGlyphs();
        this.dimArray = gv.getGlyphPositions(0, sourceLength + 1, null);
    }

    public Color getColor() {
        return this.foregroundColor;
    }

    public void setColor(Color color) {
        this.foregroundColor = color;
    }

    public void setAnchorSet(Collection<Anchor> anchorSet) {
        this.anchorSet = anchorSet;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public int getWidth() {
        return this.bounds.width;
    }

    @Override
    public int getHeight() {
        return this.bounds.height;
    }

    public float getSpan(int fromPos, int toPos) {
        float from = this.dimArray[fromPos * 2];
        float to = this.dimArray[(toPos + 1) * 2];
        float span = to - from;
        return span;
    }

    protected GlyphVector createLine(int from, int to) {
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(this.source, from, to + 1);
        GlyphVector line = this.font.createGlyphVector(this.frc, iterator);
        this.lines.add(line);
        return line;
    }

    @Override
    public Rectangle setWidth(int newWidth) {
        return this.setWidth((float)newWidth);
    }

    public Rectangle setWidth(float newWidth) {
        int from;
        this.lines.clear();
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(this.source);
        int to = from = iterator.getIndex();
        while (true) {
            char ch;
            if ((ch = iterator.current()) == '\uffff') {
                if (from >= to) break;
                this.createLine(from, to - 1);
                break;
            }
            if (ch == '\n') {
                this.createLine(from, to);
                from = ++to;
                iterator.next();
                continue;
            }
            float fwidth = this.getSpan(from, to);
            if (fwidth > newWidth) {
                if (from < to) {
                    this.createLine(from, to - 1);
                    from = to;
                    continue;
                }
                this.createLine(from, to);
                from = ++to;
                iterator.next();
                continue;
            }
            ++to;
            iterator.next();
        }
        int totalWidth = 0;
        int totalHeight = 0;
        for (GlyphVector gv : this.lines) {
            Rectangle2D r2d = gv.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            totalWidth = Math.max(totalWidth, rect.width);
            totalHeight += rect.height;
        }
        this.bounds.width = totalWidth;
        this.bounds.height = totalHeight;
        return this.bounds;
    }

    @Override
    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    @Override
    public void setFontInfo(Font font, FontRenderContext frc) {
        this.font = font;
        this.frc = frc;
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(this.source);
        GlyphVector gv = this.font.createGlyphVector(this.frc, iterator);
        int sourceLength = gv.getNumGlyphs();
        this.dimArray = gv.getGlyphPositions(0, sourceLength + 1, null);
        int width = this.getWidth();
        this.setWidth(width);
    }

    public int getCharIndex(Point pt) {
        if (!this.bounds.contains(pt)) {
            return -1;
        }
        int sPos = 0;
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        for (GlyphVector gv : this.lines) {
            Rectangle2D r2d = gv.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            rect.x = xPos;
            rect.y = yPos;
            int sourceLength = gv.getNumGlyphs();
            if (rect.contains(pt)) {
                for (int pos = 0; pos < sourceLength; ++pos) {
                    float span = this.getSpan(sPos, sPos + pos);
                    if (!(span + (float)xPos > (float)pt.x)) continue;
                    return sPos + pos;
                }
                return -1;
            }
            yPos += rect.height;
            sPos += sourceLength;
        }
        return -1;
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        if (this.selectStart < 0 || this.selectLast < 0) {
            return appendable;
        }
        CharSequence subsel = this.source.subSequence(this.selectStart, this.selectLast + 1);
        appendable.append(subsel);
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.selectStart = -1;
        this.selectLast = -1;
    }

    public void select(int start, int last) {
        if (start < last) {
            this.selectStart = start;
            this.selectLast = last;
        } else {
            this.selectStart = last;
            this.selectLast = start;
        }
        this.selectLast = Math.min(this.source.length() - 1, this.selectLast);
    }

    @Override
    public void drag(Point fromPt, Point toPt) {
        int toDirection;
        int fromDirection;
        if (fromPt.y > toPt.y || fromPt.y == toPt.y && fromPt.x > toPt.x) {
            Point swapPt = fromPt;
            fromPt = toPt;
            toPt = swapPt;
        }
        if ((fromDirection = GUIUtils.getDirection(this.bounds, fromPt)) == (toDirection = GUIUtils.getDirection(this.bounds, toPt)) && (fromDirection == 1 || fromDirection == 5)) {
            this.clearSelect();
            return;
        }
        int fromIndex = -1;
        int toIndex = -1;
        if (fromDirection == 1) {
            fromIndex = 0;
        }
        if (toDirection == 5) {
            toIndex = this.source.length() - 1;
        }
        if (fromIndex < 0) {
            fromIndex = this.getCharIndex(fromPt);
        }
        if (toIndex < 0) {
            toIndex = this.getCharIndex(toPt);
        }
        if (fromIndex >= 0 && toIndex >= 0) {
            this.select(fromIndex, toIndex);
            return;
        }
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        int accumPos = 0;
        for (GlyphVector gv : this.lines) {
            int dir;
            int glyphStart = accumPos;
            int glyphLast = accumPos + gv.getNumGlyphs() - 1;
            Rectangle2D r2d = gv.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            rect.x += xPos;
            rect.y = yPos;
            if (fromIndex < 0 && GUIUtils.getDirection(rect, fromPt) == 5) {
                yPos += rect.height;
                accumPos = glyphLast + 1;
                continue;
            }
            if (toIndex < 0 && GUIUtils.getDirection(rect, toPt) == 1) break;
            if (fromIndex < 0) {
                dir = GUIUtils.getDirection(rect, fromPt);
                if (dir == 3) {
                    fromIndex = glyphStart;
                } else if (dir == 7) {
                    fromIndex = glyphLast + 1;
                }
            }
            if (toIndex < 0) {
                dir = GUIUtils.getDirection(rect, toPt);
                if (dir == 3) {
                    toIndex = glyphStart - 1;
                } else if (dir == 7) {
                    toIndex = glyphLast;
                }
            }
            if (fromIndex >= 0 && toIndex >= 0) {
                this.select(fromIndex, toIndex);
                return;
            }
            yPos += rect.height;
            accumPos = glyphLast + 1;
        }
        this.clearSelect();
    }

    private void paintRegexHitted(Graphics2D g) {
        if (this.matchList.size() <= 0) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        int xPos = this.bounds.x;
        int yPos = this.bounds.y + ascent;
        int accumPos = 0;
        for (GlyphVector line : this.lines) {
            int glyphStart = accumPos;
            int glyphLast = accumPos + line.getNumGlyphs() - 1;
            for (MatchInfo match : this.matchList) {
                int matchStart = match.getStartPos();
                int matchLast = match.getEndPos() - 1;
                if (matchLast < glyphStart) continue;
                if (glyphLast < matchStart) break;
                int hilightStart = Math.max(matchStart, glyphStart);
                int hilightLast = Math.min(matchLast, glyphLast);
                Shape shape = line.getGlyphLogicalBounds(hilightStart - glyphStart);
                Rectangle hilight = shape.getBounds();
                shape = line.getGlyphLogicalBounds(hilightLast - glyphStart);
                hilight.add(shape.getBounds());
                if (match == this.hotTarget) {
                    g.setColor(COLOR_HOTTARGET);
                } else {
                    g.setColor(COLOR_SEARCHHIT);
                }
                g.fillRect(xPos + hilight.x, yPos + hilight.y, hilight.width, hilight.height);
            }
            Rectangle2D r2d = line.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            yPos += rect.height;
            accumPos = glyphLast + 1;
        }
    }

    private void paintSelected(Graphics2D g) {
        if (this.selectStart < 0 || this.selectLast < 0) {
            return;
        }
        g.setColor(COLOR_SELECTION);
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        int accumPos = 0;
        for (GlyphVector line : this.lines) {
            int glyphStart = accumPos;
            int glyphLast = accumPos + line.getNumGlyphs() - 1;
            if (this.selectLast < glyphStart) break;
            Rectangle2D r2d = line.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            if (glyphLast < this.selectStart) {
                yPos += rect.height;
                accumPos = glyphLast + 1;
                continue;
            }
            int hilightStart = Math.max(this.selectStart, glyphStart);
            int hilightLast = Math.min(this.selectLast, glyphLast);
            Shape shape = line.getGlyphLogicalBounds(hilightStart - glyphStart);
            Rectangle hilight = shape.getBounds();
            shape = line.getGlyphLogicalBounds(hilightLast - glyphStart);
            hilight.add(shape.getBounds());
            g.fillRect(xPos + hilight.x, yPos, hilight.width, hilight.height);
            yPos += rect.height;
            accumPos = glyphLast + 1;
        }
    }

    private void paintAnchorBack(Graphics2D g) {
        if (this.anchorSet == null) {
            return;
        }
        if (this.anchorSet.size() <= 0) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        g.setColor(Color.GRAY);
        int xPos = this.bounds.x;
        int yPos = this.bounds.y + ascent;
        int accumPos = 0;
        for (GlyphVector line : this.lines) {
            int glyphStart = accumPos;
            int glyphLast = accumPos + line.getNumGlyphs() - 1;
            for (Anchor anchor : this.anchorSet) {
                int anchorStart = anchor.getStartPos();
                int anchorLast = anchor.getEndPos() - 1;
                if (anchorLast < glyphStart) continue;
                if (glyphLast < anchorStart) break;
                int hilightStart = Math.max(anchorStart, glyphStart);
                int hilightLast = Math.min(anchorLast, glyphLast);
                Shape shape = line.getGlyphLogicalBounds(hilightStart - glyphStart);
                Rectangle hilight = shape.getBounds();
                shape = line.getGlyphLogicalBounds(hilightLast - glyphStart);
                hilight.add(shape.getBounds());
                g.fillRect(xPos + hilight.x, yPos + hilight.y, hilight.width, hilight.height);
            }
            Rectangle2D r2d = line.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            yPos += rect.height;
            accumPos = glyphLast + 1;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        int xPos = this.bounds.x;
        int yPos = this.bounds.y + ascent;
        this.paintAnchorBack(g);
        this.paintRegexHitted(g);
        this.paintSelected(g);
        g.setColor(this.foregroundColor);
        for (GlyphVector gv : this.lines) {
            g.drawGlyphVector(gv, xPos, yPos);
            Rectangle2D r2d = gv.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            yPos += rect.height;
        }
    }

    public Anchor getAnchor(Point pt) {
        int targetIdx = this.getCharIndex(pt);
        if (targetIdx < 0) {
            return null;
        }
        for (Anchor anchor : this.anchorSet) {
            int anchorStart = anchor.getStartPos();
            int anchorEnd = anchor.getEndPos();
            if (anchorStart > targetIdx || targetIdx > anchorEnd - 1) continue;
            return anchor;
        }
        return null;
    }

    public int getRegexMatchIndex(Point pt) {
        int targetIdx = this.getCharIndex(pt);
        if (targetIdx < 0) {
            return -1;
        }
        int index = 0;
        for (MatchInfo info : this.matchList) {
            int matchStart = info.getStartPos();
            int matchEnd = info.getEndPos();
            if (matchStart <= targetIdx && targetIdx <= matchEnd - 1) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int setRegex(Pattern searchRegex) {
        int endPos;
        int startPos;
        this.clearHotTarget();
        this.matchList.clear();
        if (searchRegex == null) {
            return 0;
        }
        Matcher matcher = searchRegex.matcher(this.source);
        while (matcher.find() && (startPos = matcher.start()) < (endPos = matcher.end())) {
            MatchInfo matchInfo = new MatchInfo(startPos, endPos);
            this.matchList.add(matchInfo);
        }
        return this.getRegexMatches();
    }

    public int getHotTargetIndex() {
        return this.matchList.indexOf(this.hotTarget);
    }

    public void setHotTargetIndex(int index) {
        if (index < 0) {
            this.clearHotTarget();
            return;
        }
        this.hotTarget = this.matchList.get(index);
    }

    public int getRegexMatches() {
        return this.matchList.size();
    }

    public void clearHotTarget() {
        this.hotTarget = null;
    }

    public Rectangle getHotTargetRectangle() {
        Rectangle result = null;
        if (this.hotTarget == null) {
            return result;
        }
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        int accumPos = 0;
        int matchStart = this.hotTarget.getStartPos();
        int matchLast = this.hotTarget.getEndPos() - 1;
        for (GlyphVector gv : this.lines) {
            int glyphStart = accumPos;
            int glyphLast = accumPos + gv.getNumGlyphs() - 1;
            if (matchLast < glyphStart) break;
            if (matchStart <= glyphLast) {
                int hilightStart = Math.max(matchStart, glyphStart);
                int hilightLast = Math.min(matchLast, glyphLast);
                Shape shape = gv.getGlyphLogicalBounds(hilightStart - glyphStart);
                Rectangle hilight = shape.getBounds();
                shape = gv.getGlyphLogicalBounds(hilightLast - glyphStart);
                hilight.add(shape.getBounds());
                Rectangle temp = new Rectangle(xPos + hilight.x, yPos, hilight.width, hilight.height);
                if (result == null) {
                    result = temp;
                } else {
                    result.add(temp);
                }
            }
            Rectangle2D r2d = gv.getLogicalBounds();
            Rectangle rect = r2d.getBounds();
            yPos += rect.height;
            accumPos = glyphLast + 1;
        }
        return result;
    }

    private static class MatchInfo {
        private final int startPos;
        private final int endPos;

        public MatchInfo(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

