/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.RegexPattern;

public class FindPanel
extends JDialog
implements ActionListener,
ItemListener,
ChangeListener,
WindowListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u691c\u7d22 - " + Jindolf.TITLE;
    private static final int IGNORECASEFLAG = 66;
    private static final RegexPattern INITITEM = new RegexPattern("", false, 98);
    private final JComboBox findBox = new JComboBox();
    private final JButton searchButton = new JButton("\u691c\u7d22");
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JCheckBox capitalSwitch = new JCheckBox("\u5927\u6587\u5b57/\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3059\u308b");
    private final JCheckBox regexSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe");
    private final JCheckBox dotallSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \".\" \u3092\u884c\u672b\u8a18\u53f7\u306b\u3082\u30de\u30c3\u30c1\u3055\u305b\u308b");
    private final JCheckBox multilineSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \"^\" \u3084 \"$\" \u3092\u884c\u672b\u8a18\u53f7\u306e\u524d\u5f8c\u306b\u53cd\u5fdc\u3055\u305b\u308b");
    private final JCheckBox bulkSearchSwitch = new JCheckBox("\u5168\u65e5\u7a0b\u3092\u4e00\u62ec\u691c\u7d22");
    private final JButton closeButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private boolean isCanceled = false;
    private RegexPattern regexPattern = null;

    public FindPanel(Frame owner) {
        super(owner, FRAMETITLE, true);
        this.setResizable(true);
        Toolkit kit = this.getToolkit();
        kit.setDynamicLayout(false);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.design();
        ComboBoxModel model = this.createInitModel();
        this.findBox.setModel(model);
        this.findBox.setToolTipText("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.findBox.setEditable(true);
        this.searchButton.setToolTipText("\u767a\u8a00\u5185\u5bb9\u3092\u691c\u7d22\u3059\u308b");
        this.clearButton.setToolTipText("\u5165\u529b\u3092\u30af\u30ea\u30a2\u3059\u308b");
        this.findBox.addItemListener(this);
        this.searchButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.regexSwitch.addChangeListener(this);
        this.closeButton.addActionListener(this);
        this.setRegexPattern(null);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        TitledBorder border = BorderFactory.createTitledBorder("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.findBox, "Center");
        panel.setBorder(border);
        content.add((Component)panel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 15;
        content.add((Component)this.searchButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.clearButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.capitalSwitch, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.regexSwitch, constraints);
        JPanel regexPanel = new JPanel();
        regexPanel.setBorder(BorderFactory.createTitledBorder(""));
        regexPanel.setLayout(new GridLayout(2, 1));
        regexPanel.add(this.dotallSwitch);
        regexPanel.add(this.multilineSwitch);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)regexPanel, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        content.add((Component)this.bulkSearchSwitch, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        content.add((Component)this.closeButton, constraints);
    }

    private ComboBoxModel createInitModel() {
        DefaultComboBoxModel<RegexPattern> model = new DefaultComboBoxModel<RegexPattern>();
        model.addElement(INITITEM);
        model.addElement(new RegexPattern("\u3010[^\u3011]*\u3011", true, 32, "     \u203b \u91cd\u8981\u4e8b\u9805"));
        model.addElement(new RegexPattern("[\u25a0\u25cf\u25bc\u2605\u25a1\u25cb\u25bd\u2606\u3007\u25ef\u2207]", true, 32, "     \u203b \u8b70\u984c"));
        model.addElement(new RegexPattern("Jindolf", false, 66, "     \u203b \u5ba3\u4f1d"));
        return model;
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        this.getRootPane().setDefaultButton(this.searchButton);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isBulkSearch() {
        return this.bulkSearchSwitch.isSelected();
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void actionSubmit() {
        Object selected = this.findBox.getSelectedItem();
        if (selected == null) {
            this.regexPattern = null;
            return;
        }
        String edit = selected.toString();
        boolean isRegex = this.regexSwitch.isSelected();
        int flag = 0;
        if (!this.capitalSwitch.isSelected()) {
            flag |= 0x42;
        }
        if (this.dotallSwitch.isSelected()) {
            flag |= 0x20;
        }
        if (this.multilineSwitch.isSelected()) {
            flag |= 8;
        }
        try {
            this.regexPattern = new RegexPattern(edit, isRegex, flag);
        }
        catch (PatternSyntaxException e) {
            this.regexPattern = null;
            if (this.showRegexError(e)) {
                return;
            }
            this.actionCancel();
            return;
        }
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private boolean showRegexError(PatternSyntaxException e) {
        String pattern = e.getPattern();
        String position = "";
        int index = e.getIndex();
        if (0 <= index && index <= pattern.length() - 1) {
            char errChar = pattern.charAt(index);
            position = "\u30a8\u30e9\u30fc\u306e\u767a\u751f\u7b87\u6240\u306f\u3001\u304a\u304a\u3088\u305d" + (index + 1) + "\u6587\u5b57\u76ee [ " + errChar + " ] " + "\u304b\u305d\u306e\u524d\u5f8c\u3068\u63a8\u6e2c\u3055\u308c\u307e\u3059\u3002\n";
        }
        String message = "\u5165\u529b\u3055\u308c\u305f\u691c\u7d22\u6587\u5b57\u5217 [ " + pattern + " ] \u306f" + "\u6b63\u3057\u3044\u6b63\u898f\u8868\u73fe\u3068\u3057\u3066\u8a8d\u8b58\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + position + "\u6b63\u898f\u8868\u73fe\u306e\u66f8\u304d\u65b9\u306f" + " [ http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/" + "java/util/regex/Pattern.html#sum ] " + "\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n" + "\u305f\u3060\u306e\u6587\u5b57\u5217\u3092\u691c\u7d22\u3057\u305f\u3044\u5834\u5408\u306f" + "\u300c\u6b63\u898f\u8868\u73fe\u300d\u306e\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u3092\u5916\u3057\u307e\u3057\u3087\u3046\u3002\n";
        String REENTER = "\u518d\u5165\u529b";
        String IGNORE = "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb";
        Icon icon = null;
        Object[] buttons = new Object[]{"\u518d\u5165\u529b", "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb"};
        int optionNo = JOptionPane.showOptionDialog(this, message, "\u4e0d\u6b63\u306a\u6b63\u898f\u8868\u73fe", 0, 0, icon, buttons, "\u518d\u5165\u529b");
        if (optionNo == -1) {
            return false;
        }
        if (buttons[optionNo] == "\u518d\u5165\u529b") {
            return true;
        }
        return buttons[optionNo] != "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb";
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(RegexPattern pattern) {
        this.regexPattern = pattern == null ? INITITEM : pattern;
        String edit = this.regexPattern.getEditSource();
        this.findBox.setSelectedItem(edit);
        this.regexSwitch.setSelected(this.regexPattern.isRegex());
        int initflag = this.regexPattern.getFlag();
        this.capitalSwitch.setSelected((initflag & 0x42) == 0);
        this.dotallSwitch.setSelected((initflag & 0x20) != 0);
        this.multilineSwitch.setSelected((initflag & 8) != 0);
        this.maskRegexUI();
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.actionCancel();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.actionCancel();
        } else if (source == this.searchButton) {
            this.actionSubmit();
        } else if (source == this.clearButton) {
            this.findBox.setSelectedItem("");
        }
    }

    public void itemStateChanged(ItemEvent event) {
        int stateChange = event.getStateChange();
        if (stateChange != 1) {
            return;
        }
        Object item = event.getItem();
        if (!(item instanceof RegexPattern)) {
            return;
        }
        RegexPattern regex = (RegexPattern)item;
        this.setRegexPattern(regex);
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() != this.regexSwitch) {
            return;
        }
        this.maskRegexUI();
    }

    private void maskRegexUI() {
        boolean isRegex = this.regexSwitch.isSelected();
        this.dotallSwitch.setEnabled(isRegex);
        this.multilineSwitch.setEnabled(isRegex);
    }
}

