/*
 * Dummy logging handler
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: PileHandler.java 108 2008-07-14 17:09:40Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 * なにもしないロギングハンドラ。
 * あとからなにがロギングされたのか一括して出力することができる。
 */
public class PileHandler extends Handler{
    
    private List<LogRecord> logList = new Vector<LogRecord>();
    
    /**
     * ロギングハンドラを生成する。
     */
    public PileHandler(){
        super();
        return;
    }
    
    /**
     * ログを内部に溜め込む
     * @param record ログレコード
     */
    public void publish(LogRecord record){
       	if( ! isLoggable(record) ){
            return;
	}
        logList.add(record);
        return;
    }

    /**
     * 出力フラッシュ。（何もしない）
     */
    public void flush(){
        return;
    }
    
    /**
     * ロギングハンドラを閉じる。
     */
    public void close(){
        setLevel(Level.OFF);
        flush();
        return;
    }
    
    /**
     * 他のハンドラへ蓄積したログをまとめて出力する。
     * @param handler 他のハンドラ
     */
    public void delegate(Handler handler){
        if(handler == this) return;

        close();
        
        for(LogRecord record : logList){
            handler.publish(record);
        }
        
        handler.flush();
        logList.clear();
        
        return;
    }
}
