/*
 * action manager
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: ActionManager.java 221 2008-09-30 15:00:14Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

/**
 * メニュー、ボタン、その他各種Actionを伴うイベントを生成する
 * コンポーネントの一括管理
 */
public class ActionManager{
    
    public static final String COMMAND_EXIT  = "EXIT";
    public static final String COMMAND_ABOUT = "ABOUT";
    public static final String COMMAND_LANDF = "LANDF";
    public static final String COMMAND_HELPDOC = "HELPDOC";
    public static final String COMMAND_FILTER = "FILTER";
    public static final String COMMAND_ACCOUNT = "ACCOUNT";
    public static final String COMMAND_RELOAD = "RELOAD";
    public static final String COMMAND_COPY = "COPY";
    public static final String COMMAND_PRINT = "PRINT";
    public static final String COMMAND_SELALL = "SELALL";
    public static final String COMMAND_COPYTALK = "SELTALK";
    public static final String COMMAND_SWITCHORDER = "SWITCHORDER";
    public static final String COMMAND_VILLAGELIST = "VILLAGELIST";
    public static final String COMMAND_SHOWLOG = "SHOWLOG";
    public static final String COMMAND_FONTSELECT = "FONTSELECT";
    public static final String COMMAND_FONTSIZESEL = "FONTSIZESEL";
    public static final String COMMAND_FONTAPPLY = "FONTAPPLY";
    public static final String COMMAND_FONTCANCEL = "FONTCANCEL";
    public static final String COMMAND_SEARCHNEXT = "SEARCHNEXT";
    public static final String COMMAND_SEARCHPREV = "SEARCHPREV";
    public static final String COMMAND_SHOWFIND = "FIND";
    public static final String COMMAND_ALLPERIOD = "LOADALLPERIOD";
    
    public static KeyStroke keyF1 = KeyStroke.getKeyStroke("F1");
    public static KeyStroke keyF3 = KeyStroke.getKeyStroke("F3");
    public static KeyStroke keyShiftF3 = KeyStroke.getKeyStroke("shift F3");
    public static KeyStroke keyF5 = KeyStroke.getKeyStroke("F5");
    public static KeyStroke keyCtrlF = KeyStroke.getKeyStroke("ctrl F");
    
    private Set<AbstractButton> items = new HashSet<AbstractButton>();

    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu menuVillage;
    private JMenu menuDay;
    private JMenu menuLook;
    private JMenu menuPreference;
    private JMenu menuWindow;
    private JMenu menuHelp;

    private JMenuItem itemExit;
    private JMenuItem itemAbout;
    private JMenuItem itemHelpDoc;
    private JMenuItem itemFilter;
    private JMenuItem itemAccount;
    private JMenuItem itemShowLog;
    private JMenuItem itemFontSelect;
    private JMenuItem itemCopy;
    private JMenuItem itemFind;
    private JMenuItem itemSearchPrev;
    private JMenuItem itemSearchNext;
    private JMenuItem itemReloadDay;
    private JMenuItem itemLoadAllPeriod;

    private ButtonGroup landfGroup = new ButtonGroup();
    private Map<ButtonModel, String> landfMap
        = new HashMap<ButtonModel, String>();
    
    private final JButton reloadPeriodButton = new JButton();
    private final JButton showFindButton = new JButton();
    private final JButton searchNextButton = new JButton();
    private final JButton searchPrevButton = new JButton();

    private final JMenuBar menuBar;
    private final JToolBar browseToolBar;
    
    public ActionManager(){
        this.itemExit  = new JMenuItem("終了(X)");
        this.itemAbout = new JMenuItem(Jindolf.TITLE + "について...(A)");
        this.itemHelpDoc = new JMenuItem("ヘルプ表示(H)");
        this.itemFilter = new JMenuItem("発言フィルタ(F)");
        this.itemAccount = new JMenuItem("アカウント管理(M)");
        this.itemShowLog = new JMenuItem("ログ表示(S)");
        this.itemFontSelect = new JMenuItem("発言表示フォント選択...(F)");
        this.itemCopy = new JMenuItem("選択範囲をコピー(C)");
        this.itemFind = new JMenuItem("検索...(F)");
        this.itemSearchPrev = new JMenuItem("前候補(P)");
        this.itemSearchNext = new JMenuItem("次候補(N)");
        this.itemReloadDay = new JMenuItem("この日をリロード(R)");
        this.itemLoadAllPeriod = new JMenuItem("全日程の一括読み込み(R)");
        
        this.itemExit .setActionCommand(COMMAND_EXIT);
        this.itemAbout.setActionCommand(COMMAND_ABOUT);
        this.itemHelpDoc.setActionCommand(COMMAND_HELPDOC);
        this.itemFilter.setActionCommand(COMMAND_FILTER);
        this.itemAccount.setActionCommand(COMMAND_ACCOUNT);
        this.itemShowLog.setActionCommand(COMMAND_SHOWLOG);
        this.itemFontSelect.setActionCommand(COMMAND_FONTSELECT);
        this.itemCopy.setActionCommand(COMMAND_COPY);
        this.itemFind.setActionCommand(COMMAND_SHOWFIND);
        this.itemSearchPrev.setActionCommand(COMMAND_SEARCHPREV);
        this.itemSearchNext.setActionCommand(COMMAND_SEARCHNEXT);
        this.itemReloadDay.setActionCommand(COMMAND_RELOAD);
        this.itemLoadAllPeriod.setActionCommand(COMMAND_ALLPERIOD);
        
        this.itemExit       .setMnemonic(KeyEvent.VK_X);
        this.itemAbout      .setMnemonic(KeyEvent.VK_A);
        this.itemHelpDoc    .setMnemonic(KeyEvent.VK_H);
        this.itemFilter     .setMnemonic(KeyEvent.VK_F);
        this.itemAccount    .setMnemonic(KeyEvent.VK_M);
        this.itemShowLog    .setMnemonic(KeyEvent.VK_S);
        this.itemFontSelect .setMnemonic(KeyEvent.VK_F);
        this.itemCopy       .setMnemonic(KeyEvent.VK_C);
        this.itemFind       .setMnemonic(KeyEvent.VK_F);
        this.itemSearchPrev .setMnemonic(KeyEvent.VK_P);
        this.itemSearchNext .setMnemonic(KeyEvent.VK_N);
        this.itemReloadDay  .setMnemonic(KeyEvent.VK_R);
        this.itemLoadAllPeriod .setMnemonic(KeyEvent.VK_R);

        this.itemFind       .setAccelerator(keyCtrlF);
        this.itemSearchPrev .setAccelerator(keyShiftF3);
        this.itemSearchNext .setAccelerator(keyF3);
        this.itemHelpDoc    .setAccelerator(keyF1);
        this.itemReloadDay  .setAccelerator(keyF5);
        
        this.items.add(this.itemExit);
        this.items.add(this.itemAbout);
        this.items.add(this.itemHelpDoc);
        this.items.add(this.itemFilter);
        this.items.add(this.itemAccount);
        this.items.add(this.itemShowLog);
        this.items.add(this.itemFontSelect);
        this.items.add(this.itemCopy);
        this.items.add(this.itemFind);
        this.items.add(this.itemSearchPrev);
        this.items.add(this.itemSearchNext);
        this.items.add(this.itemReloadDay);
        this.items.add(this.itemLoadAllPeriod);
        this.items.add(this.reloadPeriodButton);
        this.items.add(this.showFindButton);
        this.items.add(this.searchNextButton);
        this.items.add(this.searchPrevButton);
        
        createLookAndFeelMenuItems();

        this.menuBar = createMenuBar();
        this.browseToolBar = createBrowseToolBar();
        
        appearVillage(false);
        appearPeriod(false);
        
        return;
    }
    
    /**
     * L&F 一覧メニューを作成する。
     */
    private void createLookAndFeelMenuItems(){
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;

        UIManager.LookAndFeelInfo[] landfs =
                UIManager.getInstalledLookAndFeels();
        for(UIManager.LookAndFeelInfo lafInfo : landfs){
            String name      = lafInfo.getName();
            String className = lafInfo.getClassName();

            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(COMMAND_LANDF);

            if(className.equals(currentName)) matchedButton = button;

            this.items.add(button);
            this.landfGroup.add(button);
            this.landfMap.put(button.getModel(), className);
        }

        if(matchedButton != null) matchedButton.setSelected(true);

        return;
    }
    
    /**
     * 現在メニューで選択中のL&Fのクラス名を返す。
     * @return L&F クラス名
     */
    public String getSelectedLookAndFeel(){
        ButtonModel selected = this.landfGroup.getSelection();
        if(selected == null) return null;
        String className = this.landfMap.get(selected);
        return className;
    }
    
    /**
     * 全てのボタンにリスナー登録する。
     * @param listener リスナー
     */
    public void addActionListener(ActionListener listener){
        for(AbstractButton button : this.items){
            button.addActionListener(listener);
        }
        return;
    }
    
    /**
     * メニューバーを生成する。
     * @return メニューバー
     */
    private JMenuBar createMenuBar(){
        JMenuBar bar;

        this.menuFile = new JMenu("ファイル(F)");
        this.menuEdit = new JMenu("編集(E)");
        this.menuVillage = new JMenu("村(V)");
        this.menuDay = new JMenu("日(D)");
        this.menuPreference = new JMenu("設定(P)");
        this.menuWindow = new JMenu("ウィンドウ(W)");
        this.menuHelp = new JMenu("ヘルプ(H)");

        this.menuFile       .setMnemonic(KeyEvent.VK_F);
        this.menuEdit       .setMnemonic(KeyEvent.VK_E);
        this.menuVillage    .setMnemonic(KeyEvent.VK_V);
        this.menuDay        .setMnemonic(KeyEvent.VK_D);
        this.menuPreference .setMnemonic(KeyEvent.VK_P);
        this.menuWindow     .setMnemonic(KeyEvent.VK_W);
        this.menuHelp       .setMnemonic(KeyEvent.VK_H);

        this.menuFile.add(this.itemExit);
        this.menuEdit.add(this.itemCopy);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.itemFind);
        this.menuEdit.add(this.itemSearchPrev);
        this.menuEdit.add(this.itemSearchNext);
        this.menuVillage.add(this.itemLoadAllPeriod);
        this.menuDay.add(this.itemReloadDay);
        this.menuWindow.add(this.itemFilter);
        this.menuWindow.add(this.itemAccount);
        this.menuWindow.add(this.itemShowLog);
        this.menuHelp.add(this.itemHelpDoc);
        this.menuHelp.addSeparator();
        this.menuHelp.add(this.itemAbout);

        this.menuLook = new JMenu("ルック&フィール(L)");
        this.menuLook.setMnemonic(KeyEvent.VK_L);
        Enumeration<AbstractButton> landfButtons =
                this.landfGroup.getElements();
        while(landfButtons.hasMoreElements()){
            JMenuItem item = (JMenuItem)( landfButtons.nextElement() );
            this.menuLook.add(item);
        }

        this.menuPreference.add(this.itemFontSelect);
        this.menuPreference.addSeparator();
        this.menuPreference.add(this.menuLook);
        
        bar = new JMenuBar();
        bar.add(this.menuFile);
        bar.add(this.menuEdit);
        bar.add(this.menuVillage);
        bar.add(this.menuDay);
        bar.add(this.menuPreference);
        bar.add(this.menuWindow);
        bar.add(this.menuHelp);
         
        return bar;
    }

    /**
     * メニューバーを取得する。
     * @return メニューバー
     */
    public JMenuBar getMenuBar(){
        return this.menuBar;
    }
    
    /**
     * ブラウザ用ツールバーの生成を行う。
     * @return ツールバー
     */
    private JToolBar createBrowseToolBar(){
        URL url;
        url = Jindolf.getResource("resources/image/reload.png");
        ImageIcon reloadIcon = new ImageIcon(url);
        this.reloadPeriodButton.setIcon(reloadIcon);
        url = Jindolf.getResource("resources/image/find.png");
        ImageIcon findIcon = new ImageIcon(url);
        this.showFindButton.setIcon(findIcon);
        url = Jindolf.getResource("resources/image/findprev.png");
        ImageIcon findPrevIcon = new ImageIcon(url);
        this.searchPrevButton.setIcon(findPrevIcon);
        url = Jindolf.getResource("resources/image/findnext.png");
        ImageIcon findNextIcon = new ImageIcon(url);
        this.searchNextButton.setIcon(findNextIcon);
        
        this.reloadPeriodButton
                .setToolTipText("選択された日の発言をリロードする");
        this.showFindButton.setToolTipText("検索");
        this.searchPrevButton.setToolTipText("↑前候補");
        this.searchNextButton.setToolTipText("↓次候補");
        
        this.reloadPeriodButton.setMargin(new Insets(1, 1, 1, 1));
        this.showFindButton.setMargin(new Insets(1, 1, 1, 1));
        this.searchPrevButton.setMargin(new Insets(1, 1, 1, 1));
        this.searchNextButton.setMargin(new Insets(1, 1, 1, 1));
        
        this.reloadPeriodButton.setActionCommand(
                ActionManager.COMMAND_RELOAD);
        this.showFindButton.setActionCommand(
                ActionManager.COMMAND_SHOWFIND);
        this.searchNextButton.setActionCommand(
                ActionManager.COMMAND_SEARCHNEXT);
        this.searchPrevButton.setActionCommand(
                ActionManager.COMMAND_SEARCHPREV);

        JToolBar toolBar = new JToolBar();
        toolBar.add(this.reloadPeriodButton);
        toolBar.addSeparator();
        toolBar.add(this.showFindButton);
        toolBar.add(this.searchNextButton);
        toolBar.add(this.searchPrevButton);
        
        return toolBar;
    }

    /**
     * ブラウザ用ツールバーを取得する。
     * @return ツールバー
     */
    public JToolBar getBrowseToolBar(){
        return this.browseToolBar;
    }
    
    /**
     * Periodが表示されているか通知を受ける。
     * @param appear 表示されているときはtrue
     */
    public void appearPeriod(boolean appear){
        if(appear) appearVillage(appear);
        
        this.menuEdit.setEnabled(appear);
        this.menuDay.setEnabled(appear);
        
        this.reloadPeriodButton.setEnabled(appear);
        this.showFindButton.setEnabled(appear);
        this.searchNextButton.setEnabled(appear);
        this.searchPrevButton.setEnabled(appear);

        return;
    }
    
    /**
     * 村が表示されているか通知を受ける。
     * @param appear 表示されているときはtrue
     */
    public void appearVillage(boolean appear){
        if( ! appear) appearPeriod(appear);
        this.menuVillage.setEnabled(appear);
        return;
    }
}
