/*
 * テキスト描画基本インタフェース
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: RowsLtoR.java 154 2008-09-04 16:15:41Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.IOException;

/**
 * 矩形に複数行のテキストを配置・描画する「なにものか」を表すインタフェース。
 * この場合、「行」とは左から右へ水平方向にグリフを並べたもの。
 */
public interface RowsLtoR{
    
    /**
     * 新しい幅を指定し、寸法の再計算、内部の再レイアウトを促す。
     * @param newWidth 新しいピクセル幅
     * @return 新しい寸法
     */
    public Rectangle setWidth(int newWidth);

    /**
     * 描画領域の寸法を返す。
     * @return 描画領域の寸法
     */
    public Rectangle getBounds();

    /**
     * 描画開始位置の指定。
     * @param xPos 描画開始位置のx座標
     * @param yPos 描画開始位置のy座標
     */
    public void setPos(int xPos, int yPos);

    /**
     * 描画領域の寸法幅を返す。
     * @return 描画領域の寸法幅
     */
    public int getWidth();

    /**
     * 描画領域の寸法高を返す。
     * @return 描画領域の寸法高
     */
    public int getHeight();

    /**
     * フォント描画設定を変更する。
     * @param font フォント
     * @param frc フォント描画設定
     */
    public void setFontInfo(Font font, FontRenderContext frc);
    
    /**
     * ドラッグ処理を行う。
     * @param from ドラッグ開始位置
     * @param to 現在のドラッグ位置
     */
    public void drag(Point from, Point to);
    
    /**
     * 受け取った文字列に選択文字列を追加する。
     * @param appendable 追加対象文字列
     * @return 引数と同じインスタンス
     * @throws java.io.IOException
     */
    public Appendable appendSelected(Appendable appendable)
            throws IOException; 
    
    /**
     * 選択範囲の解除。
     */
    public void clearSelect();
    
    /**
     * 描画を行う。
     * @param g グラフィックコンテキスト
     */
    public void paint(Graphics2D g);

}
