/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.VillageIconRenderer;

public class LandsTree
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private static final String ascendingSymbol = "\u2191";
    private static final String descendingSymbol = "\u2193";
    private static final String ascendingTip = "\u62bc\u3059\u3068\u964d\u9806\u306b";
    private static final String descendingTip = "\u62bc\u3059\u3068\u6607\u9806\u306b";
    private static final String orderTip = "\u9078\u629e\u4e2d\u306e\u56fd\u306e\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u76f4\u3059";
    private final JButton orderButton = new JButton("\u2193");
    private final JButton reloadButton = new JButton("\u6751\u4e00\u89a7\u8aad\u8fbc");
    private final JTree treeView = new JTree();
    private boolean ascending = false;

    public LandsTree() {
        this.design();
        this.orderButton.setToolTipText(descendingTip);
        this.orderButton.setActionCommand("SWITCHORDER");
        this.orderButton.addActionListener(this);
        this.reloadButton.setToolTipText(orderTip);
        this.reloadButton.setActionCommand("VILLAGELIST");
        this.treeView.addTreeSelectionListener(this);
    }

    private void design() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        this.add((Component)this.orderButton, constraints);
        constraints.gridwidth = 0;
        this.add((Component)this.reloadButton, constraints);
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.createLandSelector(), constraints);
    }

    private JComponent createLandSelector() {
        this.treeView.setRootVisible(false);
        this.treeView.setCellRenderer(new VillageIconRenderer());
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        this.treeView.setBorder(border);
        JScrollPane landSelector = new JScrollPane(this.treeView);
        return landSelector;
    }

    public JButton getReloadVillageListButton() {
        return this.reloadButton;
    }

    public JTree getTreeView() {
        return this.treeView;
    }

    public void expandLand(Land land) {
        TreeModel model = this.treeView.getModel();
        Object root = model.getRoot();
        Object[] path = new Object[]{root, land};
        TreePath treePath = new TreePath(path);
        this.treeView.expandPath(treePath);
        this.updateReloadButton(land);
    }

    private void updateReloadButton(Land land) {
        if (land.getVillageCount() <= 0) {
            this.reloadButton.setText("\u6751\u4e00\u89a7\u8aad\u8fbc");
        } else {
            this.reloadButton.setText("\u518d\u8aad\u8fbc");
        }
    }

    private LandsModel getLandsModel() {
        TreeModel model = this.treeView.getModel();
        if (model instanceof LandsModel) {
            return (LandsModel)model;
        }
        return null;
    }

    private boolean toggleTreeOrder() {
        boolean bl = this.ascending = !this.ascending;
        if (this.ascending) {
            this.orderButton.setToolTipText(ascendingTip);
            this.orderButton.setText(ascendingSymbol);
        } else {
            this.orderButton.setToolTipText(descendingTip);
            this.orderButton.setText(descendingSymbol);
        }
        final TreePath lastPath = this.treeView.getSelectionPath();
        LandsModel model = this.getLandsModel();
        if (model != null) {
            model.setAscending(this.ascending);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (lastPath != null) {
                    LandsTree.this.treeView.setSelectionPath(lastPath);
                    LandsTree.this.treeView.scrollPathToVisible(lastPath);
                }
            }
        });
        return this.ascending;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if ("SWITCHORDER".equals(cmd)) {
            this.toggleTreeOrder();
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            this.reloadButton.setEnabled(false);
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            Land land = (Land)selObj;
            this.reloadButton.setEnabled(true);
            this.updateReloadButton(land);
        } else {
            this.reloadButton.setEnabled(false);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.treeView != null) {
            this.treeView.setCellRenderer(new VillageIconRenderer());
        }
    }
}

