/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.AccountPanel;
import jp.sourceforge.jindolf.FilterPanel;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.JdfScroller;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.LogFrame;
import jp.sourceforge.jindolf.MenuManager;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.TopFrameView;
import jp.sourceforge.jindolf.UnshareStyleEditorKit;
import jp.sourceforge.jindolf.Village;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener {
    private static final String HELP_HTML = "resources/help.html";
    private MenuManager menuManager;
    private TopFrameView topFrame;
    private LandsModel model;
    private JFrame helpFrame;
    private FilterPanel filterFrame;
    private AccountPanel accountFrame;
    private LogFrame showlogFrame;

    public Controller(MenuManager menuManager, TopFrameView topFrame, LandsModel model) {
        Handler[] handlers;
        this.menuManager = menuManager;
        this.topFrame = topFrame;
        this.model = model;
        this.menuManager.addActionListener(this);
        JTree treeView = topFrame.getTreeView();
        treeView.setModel(model);
        treeView.addTreeWillExpandListener(this);
        treeView.addTreeSelectionListener(this);
        topFrame.getTabBrowser().addChangeListener(this);
        topFrame.getReloadButton().addActionListener(this);
        topFrame.getSearchButton().addActionListener(this);
        JButton reloadVillageListButton = topFrame.getLandsTree().getReloadVillageListButton();
        reloadVillageListButton.addActionListener(this);
        reloadVillageListButton.setEnabled(false);
        this.filterFrame = new FilterPanel();
        this.filterFrame.addChangeListener(this);
        this.filterFrame.pack();
        this.filterFrame.setVisible(false);
        this.showlogFrame = new LogFrame();
        this.showlogFrame.pack();
        this.showlogFrame.setSize(600, 250);
        this.showlogFrame.setLocationByPlatform(true);
        this.showlogFrame.setVisible(false);
        Handler newHandler = this.showlogFrame.getHandler();
        Jindolf.logger.addHandler(newHandler);
        for (Handler handler : handlers = Jindolf.logger.getHandlers()) {
            if (!(handler instanceof PileHandler)) continue;
            PileHandler pile = (PileHandler)handler;
            pile.delegate(newHandler);
            pile.close();
        }
    }

    private void reloadVillageList() {
        JTree tree = this.topFrame.getTreeView();
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Land land = null;
        for (int ct = 0; ct < path.getPathCount(); ++ct) {
            Object obj = path.getPathComponent(ct);
            if (!(obj instanceof Land)) continue;
            land = (Land)obj;
            break;
        }
        if (land == null) {
            return;
        }
        this.topFrame.showInitPanel();
        this.execReloadVillageList(land);
    }

    private void execReloadVillageList(final Land land) {
        final LandsTree treePanel = this.topFrame.getLandsTree();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                try {
                    try {
                        Controller.this.model.loadVillageList(land);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(land, e);
                    }
                    treePanel.expandLand(land);
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private void searchPeriod() {
        JdfBrowser browser = this.currentJdfBrowser();
        if (browser == null) {
            return;
        }
        Pattern searchRegex = this.currentPattern();
        browser.setSearchRegex(searchRegex);
        int hits = browser.highlightRegex();
        this.topFrame.updateSysMessage("\uff3b" + hits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f");
    }

    private Pattern currentPattern() {
        Pattern pattern;
        JComboBox box = this.topFrame.getFindBox();
        Object selected = box.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String searchString = selected.toString();
        if (searchString.length() <= 0) {
            return null;
        }
        try {
            pattern = Pattern.compile(searchString, 32);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        return pattern;
    }

    private void updatePeriod(final boolean force) {
        final TabBrowser tabBrowser = this.topFrame.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        this.topFrame.setFrameTitle(village.getVillageName());
        final JdfScroller scroller = this.currentJdfScroller();
        final JdfBrowser browser = this.currentJdfBrowser();
        if (browser == null) {
            return;
        }
        browser.setTopicFilter(this.filterFrame);
        final Period period = browser.getPeriod();
        if (period == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                try {
                    boolean wasHot = this.loadPeriod();
                    if (wasHot && !period.isHot() && !this.updatePeriodList()) {
                        return;
                    }
                    this.renderBrowser();
                }
                finally {
                    Controller.this.topFrame.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean wasHot;
                Controller.this.topFrame.updateSysMessage("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026");
                try {
                    wasHot = period.isHot();
                    try {
                        period.loadPeriod(force);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                    }
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                }
                return wasHot;
            }

            private boolean updatePeriodList() {
                Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u3066\u3044\u307e\u3059\u2026");
                try {
                    village.updatePeriodList();
                }
                catch (IOException e) {
                    Controller.this.showNetworkError(village, e);
                    return false;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            tabBrowser.setVillage(village);
                        }
                    });
                }
                catch (Exception e) {
                    Jindolf.logger.log(Level.SEVERE, "\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u307e\u3057\u305f\u2026");
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.topFrame.updateSysMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    final int lastPos = scroller.getVerticalPosition();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                browser.showTopics(force);
                            }
                        });
                    }
                    catch (Exception e) {
                        Jindolf.logger.log(Level.SEVERE, "\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            scroller.setVerticalPosition(lastPos);
                        }
                    });
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86");
                }
            }
        });
    }

    private void filterChanged() {
        final JdfBrowser browser = this.currentJdfBrowser();
        if (browser == null) {
            return;
        }
        browser.setTopicFilter(this.filterFrame);
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    browser.filtering();
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u5b8c\u4e86");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private JdfScroller currentJdfScroller() {
        TabBrowser tb = this.topFrame.getTabBrowser();
        JdfScroller result = tb.currentJdfScroller();
        return result;
    }

    private JdfBrowser currentJdfBrowser() {
        JdfScroller scroller = this.currentJdfScroller();
        if (scroller == null) {
            return null;
        }
        JdfBrowser result = scroller.getJdfBrowser();
        return result;
    }

    private void changeLandF() {
        LookAndFeel lnf;
        String className = this.menuManager.getSelectedLookAndFeel();
        try {
            Class<?> lnfClass = Class.forName(className);
            lnf = (LookAndFeel)lnfClass.newInstance();
        }
        catch (Exception e) {
            String message = "\u3053\u306eLook&Feel[" + className + "]\u3092\u8aad\u307f\u8fbc\u3080\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, message, e);
            JOptionPane.showMessageDialog(this.topFrame, message, "Look&Feel - " + Jindolf.title, 2);
            return;
        }
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (UnsupportedLookAndFeelException e) {
            String message = "\u3053\u306eLook&Feel[" + lnf.getName() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, message, e);
            JOptionPane.showMessageDialog(this.topFrame, message, "Look&Feel - " + Jindolf.title, 2);
            return;
        }
        Jindolf.logger.info("Look&Feel\u304c[" + lnf.getName() + "]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002");
        final Runnable updateUITask = new Runnable(){

            public void run() {
                SwingUtilities.updateComponentTreeUI(Controller.this.topFrame);
                Controller.this.topFrame.validate();
                if (Controller.this.helpFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.helpFrame);
                    Controller.this.helpFrame.validate();
                }
                if (Controller.this.showlogFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.showlogFrame);
                    Controller.this.showlogFrame.validate();
                }
                if (Controller.this.filterFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.filterFrame);
                    Controller.this.filterFrame.validate();
                    Controller.this.filterFrame.pack();
                }
                if (Controller.this.accountFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.accountFrame);
                    Controller.this.accountFrame.validate();
                    Controller.this.accountFrame.pack();
                }
            }
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026");
                try {
                    SwingUtilities.invokeAndWait(updateUITask);
                }
                catch (Exception e) {
                    Jindolf.logger.log(Level.WARNING, "Look&Feel\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private void doExit() {
        Jindolf.exit(0);
    }

    private void toggleFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.isVisible()) {
            frame.setVisible(false);
            frame.dispose();
        } else {
            frame.setVisible(true);
        }
    }

    private void showFilter() {
        this.toggleFrame(this.filterFrame);
    }

    private void showAccount() {
        if (this.accountFrame != null) {
            this.toggleFrame(this.accountFrame);
            return;
        }
        this.accountFrame = new AccountPanel(this.model);
        this.accountFrame.pack();
        this.accountFrame.setVisible(true);
    }

    private void showLog() {
        this.toggleFrame(this.showlogFrame);
    }

    private void showHelp() {
        if (this.helpFrame != null) {
            this.toggleFrame(this.helpFrame);
            return;
        }
        this.helpFrame = new JFrame(Jindolf.title + " \u30d8\u30eb\u30d7");
        this.helpFrame.setResizable(true);
        Toolkit kit = this.helpFrame.getToolkit();
        kit.setDynamicLayout(false);
        this.helpFrame.setIconImage(GUIUtils.getWindowIconImage());
        this.helpFrame.setLocationByPlatform(true);
        UnshareStyleEditorKit editorKit = new UnshareStyleEditorKit();
        JEditorPane edit = new JEditorPane();
        edit.setEditorKit(editorKit);
        edit.setEditable(false);
        edit.setContentType("text/html");
        edit.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        edit.setBorder(new EmptyBorder(0, 0, 0, 0));
        URL htmlurl = Jindolf.getResource(HELP_HTML);
        try {
            edit.setPage(htmlurl);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30d8\u30eb\u30d7\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
            this.helpFrame = null;
            return;
        }
        JScrollPane sc = new JScrollPane(edit);
        Container content = this.helpFrame.getContentPane();
        content.add(sc);
        this.helpFrame.pack();
        this.helpFrame.setSize(450, 450);
        this.helpFrame.setVisible(true);
    }

    private void showAbout() {
        String message = Jindolf.title + "   Version " + "2.6.2" + "\n" + Jindolf.copyright + "\n" + "\u30e9\u30a4\u30bb\u30f3\u30b9: " + "The MIT License" + "\n" + "\u9023\u7d61\u5148: " + "http://jindolf.sourceforge.jp/";
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(this.topFrame, Jindolf.title + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void showNetworkError(Village village, IOException e) {
        Land land = village.getParentLand();
        this.showNetworkError(land, e);
    }

    public void showNetworkError(Land land, IOException e) {
        Jindolf.logger.log(Level.WARNING, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        ServerAccess server = land.getServerAccess();
        String message = land.getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        JDialog dialog = pane.createDialog(this.topFrame, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.title);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            Land land = (Land)selObj;
            this.topFrame.showLandInfo(land);
        } else if (selObj instanceof Village) {
            final Village village = (Village)selObj;
            ExecutorService executor = Executors.newCachedThreadPool();
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Controller.this.topFrame.setBusy(true);
                    Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                    try {
                        village.updatePeriodList();
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                        return;
                    }
                    finally {
                        Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                        Controller.this.topFrame.setBusy(false);
                    }
                    Controller.this.topFrame.showVillageInfo(village);
                }
            });
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.filterFrame) {
            this.filterChanged();
        } else if (source instanceof TabBrowser) {
            JdfBrowser browser = this.currentJdfBrowser();
            if (browser == null) {
                return;
            }
            Pattern searchRegex = this.currentPattern();
            browser.setSearchRegex(searchRegex);
            this.updatePeriod(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ABOUT")) {
            this.showAbout();
        } else if (cmd.equals("EXIT")) {
            this.doExit();
        } else if (cmd.equals("LANDF")) {
            this.changeLandF();
        } else if (cmd.equals("HELPDOC")) {
            this.showHelp();
        } else if (cmd.equals("FILTER")) {
            this.showFilter();
        } else if (cmd.equals("ACCOUNT")) {
            this.showAccount();
        } else if (cmd.equals("SHOWLOG")) {
            this.showLog();
        } else if (cmd.equals("RELOAD")) {
            this.updatePeriod(true);
        } else if (cmd.equals("SEARCH")) {
            this.searchPeriod();
        } else if (cmd.equals("VILLAGELIST")) {
            this.reloadVillageList();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        if (!(event.getSource() instanceof JTree)) {
            return;
        }
        TreePath path = event.getPath();
        Object lastObj = path.getLastPathComponent();
        if (!(lastObj instanceof Land)) {
            return;
        }
        Land land = (Land)lastObj;
        if (land.getVillageCount() > 0) {
            return;
        }
        this.execReloadVillageList(land);
    }
}

