/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Jindolf;

public class AppSetting {
    private static final Map<String, String> propertyMap = new TreeMap<String, String>();
    public static final String osName;
    public static final String osVersion;
    public static final String osArch;
    public static final String javaVendor;
    public static final String javaVersion;
    public static final String classpath;
    public static final String proxyHost;
    public static final String proxyPort;
    public static final String nonProxyHosts;
    private static final Map<String, String> environmentMap;
    public static final String envLANG;
    public static final String envDISPLAY;
    public static final String[] classpaths;
    public static boolean needHelp;
    public static boolean needVersion;
    public static boolean needVMInfo;
    public static boolean boldMetal;
    public static boolean noSplash;
    public static boolean consolelog;
    public static int frameWidth;
    public static int frameHeight;
    public static int frameXpos;
    public static int frameYpos;
    private static final List<String> invokeArgs;
    private static final Pattern geomPattern;

    private static String getSecureProperty(String key) {
        String result;
        try {
            result = System.getProperty(key);
            if (result != null) {
                propertyMap.put(key, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    private static String getSecureEnvironment(String name) {
        String result;
        try {
            result = System.getenv(name);
            if (result != null) {
                environmentMap.put(name, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    public static String getVMInfo() {
        StringBuilder result = new StringBuilder();
        result.append("\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: " + Jindolf.runtime.maxMemory() + " bytes\n");
        result.append("\n");
        result.append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String arg : invokeArgs) {
            result.append("  ").append(arg).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        Set<String> propKeys = propertyMap.keySet();
        for (String propKey : propKeys) {
            if (propKey.equals("java.class.path")) continue;
            String value = propertyMap.get(propKey);
            result.append("  ");
            result.append(propKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        Set<String> envKeys = environmentMap.keySet();
        for (String envKey : envKeys) {
            String value = environmentMap.get(envKey);
            result.append("  ");
            result.append(envKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        for (String path : classpaths) {
            result.append("  ");
            result.append(path).append("\n");
        }
        return result.toString();
    }

    public static void parseOptions(String[] args) {
        invokeArgs.clear();
        for (String arg : args) {
            if (arg == null || arg.length() <= 0) continue;
            invokeArgs.add(arg);
        }
        ListIterator<String> iterator = invokeArgs.listIterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.equals("-h") || arg.equals("-help") || arg.equals("--help") || arg.equals("-?")) {
                needHelp = true;
                needVersion = false;
                continue;
            }
            if (arg.equals("-version")) {
                needVersion = true;
                needHelp = false;
                continue;
            }
            if (arg.equals("-boldMetal")) {
                boldMetal = true;
                continue;
            }
            if (arg.equals("-nosplash")) {
                noSplash = true;
                continue;
            }
            if (arg.equals("-geometry")) {
                if (!iterator.hasNext()) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                    return;
                }
                String geometry = iterator.next();
                Matcher matcher = geomPattern.matcher(geometry);
                if (!matcher.matches()) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + geometry + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    return;
                }
                String width = matcher.group(1);
                String height = matcher.group(2);
                String xSign = matcher.group(3);
                String xPos = matcher.group(4);
                String ySign = matcher.group(5);
                String yPos = matcher.group(6);
                try {
                    frameWidth = Integer.parseInt(width);
                    frameHeight = Integer.parseInt(height);
                    if (xPos != null && xPos.length() > 0) {
                        frameXpos = Integer.parseInt(xPos);
                        if (xSign.equals("-")) {
                            frameXpos = -frameXpos;
                        }
                    }
                    if (yPos == null || yPos.length() <= 0) continue;
                    frameYpos = Integer.parseInt(yPos);
                    if (!ySign.equals("-")) continue;
                    frameYpos = -frameYpos;
                    continue;
                }
                catch (NumberFormatException e) {
                    AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + geometry + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    return;
                }
            }
            if (arg.equals("-vminfo")) {
                needVMInfo = true;
                continue;
            }
            if (arg.equals("-consolelog")) {
                consolelog = true;
                continue;
            }
            AppSetting.optionError("\u672a\u5b9a\u7fa9\u306e\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
            assert (false);
        }
    }

    private static void optionError(CharSequence message) {
        System.err.println(message);
        System.err.println("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c-help\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002");
        Jindolf.runtime.exit(1);
        assert (false);
    }

    static {
        environmentMap = new TreeMap<String, String>();
        needHelp = false;
        needVersion = false;
        needVMInfo = false;
        boldMetal = false;
        noSplash = false;
        consolelog = false;
        frameWidth = 800;
        frameHeight = 600;
        frameXpos = Integer.MIN_VALUE;
        frameYpos = Integer.MIN_VALUE;
        invokeArgs = new LinkedList<String>();
        geomPattern = Pattern.compile("([1-9][0-9]*)x([1-9][0-9]*)(?:(\\+|\\-)([1-9][0-9]*)(\\+|\\-)([1-9][0-9]*))?");
        osName = AppSetting.getSecureProperty("os.name");
        osVersion = AppSetting.getSecureProperty("os.version");
        osArch = AppSetting.getSecureProperty("os.arch");
        javaVendor = AppSetting.getSecureProperty("java.vendor");
        javaVersion = AppSetting.getSecureProperty("java.version");
        classpath = AppSetting.getSecureProperty("java.class.path");
        proxyHost = AppSetting.getSecureProperty("http.proxyHost");
        proxyPort = AppSetting.getSecureProperty("http.proxyPort");
        nonProxyHosts = AppSetting.getSecureProperty("http.nonProxyHosts");
        envLANG = AppSetting.getSecureEnvironment("LANG");
        envDISPLAY = AppSetting.getSecureEnvironment("DISPLAY");
        classpaths = classpath != null ? classpath.split(File.pathSeparator) : new String[0];
    }
}

