/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.ServerAccess;

public class AccountPanel
extends JFrame
implements ActionListener,
ItemListener {
    private static final String frameTitle = "\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406 - " + Jindolf.title;
    private final LandsModel landsModel;
    private final Map<Land, String> landUserIDMap = new HashMap<Land, String>();
    private final Map<Land, char[]> landPasswordMap = new HashMap<Land, char[]>();
    private final JComboBox landBox = new JComboBox();
    private final JTextField idField = new JTextField(15);
    private final JPasswordField pwField = new JPasswordField(15);
    private final JButton loginButton = new JButton("\u30ed\u30b0\u30a4\u30f3");
    private final JButton logoutButton = new JButton("\u30ed\u30b0\u30a2\u30a6\u30c8");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final JTextField status = new JTextField();

    public AccountPanel(LandsModel landsModel) throws NullPointerException {
        super(frameTitle);
        if (landsModel == null) {
            throw new NullPointerException();
        }
        this.landsModel = landsModel;
        for (Land land : this.landsModel.getLandList()) {
            String userID = "";
            char[] password = new char[]{};
            this.landUserIDMap.put(land, userID);
            this.landPasswordMap.put(land, password);
            this.landBox.addItem(land);
        }
        this.setResizable(true);
        Toolkit kit = this.getToolkit();
        kit.setDynamicLayout(false);
        this.setIconImage(GUIUtils.getWindowIconImage());
        this.setLocationByPlatform(true);
        this.landBox.setToolTipText("\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406\u3059\u308b\u56fd\u3092\u9078\u3076");
        this.idField.setToolTipText("ID\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.pwField.setToolTipText("\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.landBox.setEditable(false);
        this.landBox.addItemListener(this);
        this.status.setEditable(false);
        this.status.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.loginButton.addActionListener(this);
        this.logoutButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.loginButton);
        Container content = this.getContentPane();
        BoxLayout boxLayout = new BoxLayout(content, 1);
        content.setLayout(boxLayout);
        JComponent accountPanel = this.createCredential();
        JComponent buttonPanel = this.createButtonPanel();
        content.add(accountPanel);
        content.add(new JSeparator());
        content.add(this.status);
        content.add(new JSeparator());
        content.add(buttonPanel);
        this.preSelectActiveLand();
        this.updateGUI();
    }

    private JComponent createCredential() {
        JPanel credential = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        credential.setLayout(layout);
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 0;
        constraints.anchor = 13;
        credential.add((Component)new JLabel("\u56fd\u540d :"), constraints);
        constraints.anchor = 17;
        credential.add((Component)this.landBox, constraints);
        constraints.gridy = 1;
        constraints.anchor = 13;
        credential.add((Component)new JLabel("ID :"), constraints);
        constraints.anchor = 17;
        credential.add((Component)this.idField, constraints);
        constraints.gridy = 2;
        constraints.anchor = 13;
        credential.add((Component)new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9 :"), constraints);
        constraints.anchor = 17;
        credential.add((Component)this.pwField, constraints);
        credential.setBorder(new EmptyBorder(10, 10, 10, 10));
        return credential;
    }

    private JComponent createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttonPanel.setLayout(layout);
        buttonPanel.add((Component)this.loginButton, constraints);
        constraints.insets = new Insets(0, 5, 0, 0);
        buttonPanel.add((Component)this.logoutButton, constraints);
        constraints.anchor = 13;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        buttonPanel.add((Component)this.closeButton, constraints);
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return buttonPanel;
    }

    protected Land getSelectedLand() {
        Land land = (Land)this.landBox.getSelectedItem();
        return land;
    }

    private void preSelectActiveLand() {
        for (int index = 0; index < this.landBox.getItemCount(); ++index) {
            Object item = this.landBox.getItemAt(index);
            Land land = (Land)item;
            Land.Type type = land.getType();
            if (type != Land.Type.ACTIVE) continue;
            this.landBox.setSelectedItem(land);
            return;
        }
    }

    private String getUserID(Land land) {
        return this.landUserIDMap.get(land);
    }

    private char[] getPassword(Land land) {
        return this.landPasswordMap.get(land);
    }

    protected void showNetworkError(IOException e) {
        Jindolf.logger.log(Level.WARNING, "\u30a2\u30ab\u30a6\u30f3\u30c8\u51e6\u7406\u4e2d\u306b\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        Land land = this.getSelectedLand();
        ServerAccess server = land.getServerAccess();
        String message = land.getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d\uff01\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        JDialog dialog = pane.createDialog(this, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.title);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    protected void showIllegalAccountDialog() {
        Land land = this.getSelectedLand();
        String message = land.getLandName() + "\u3078\u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + "\u30e6\u30fc\u30b6\u540d\u3068\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u672c\u5f53\u306b\u6b63\u3057\u3044\u304b\u306a\uff1f\n" + "\u3042\u306a\u305f\u306f\u672c\u5f53\u306b [ " + this.getUserID(land) + " ] \u3055\u3093\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u306b\u3088\u308bID\u767b\u9332\u624b\u7d9a\u304d\u306f\u672c\u5f53\u306b\u5b8c\u4e86\u3057\u3066\u308b\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u30ed\u30b0\u30a4\u30f3\u3067\u304d\u306a\u3044\u304b\u8a66\u3057\u3066\u307f\u3066\uff01\n" + "\u2026\u30e6\u30fc\u30b6\u540d\u3084\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u3042\u308b\u7a2e\u306e\u7279\u6b8a\u6587\u5b57\u3092\u4f7f\u3063\u3066\u3044\u308b\u4eba\u306f" + "\u554f\u984c\u304c\u3042\u308b\u304b\u3082\u3002";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        JDialog dialog = pane.createDialog(this, "\u30ed\u30b0\u30a4\u30f3\u8a8d\u8a3c\u5931\u6557 - " + Jindolf.title);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    protected boolean login() {
        Land land = this.getSelectedLand();
        ServerAccess server = land.getServerAccess();
        String id = this.idField.getText();
        char[] password = this.pwField.getPassword();
        this.landUserIDMap.put(land, id);
        this.landPasswordMap.put(land, password);
        boolean result = false;
        try {
            result = server.login(id, password);
        }
        catch (IOException e) {
            this.showNetworkError(e);
            return false;
        }
        if (!result) {
            this.showIllegalAccountDialog();
        }
        return result;
    }

    protected void logout() {
        try {
            this.logoutInternal();
        }
        catch (IOException e) {
            this.showNetworkError(e);
        }
    }

    protected void logoutInternal() throws IOException {
        Land land = this.getSelectedLand();
        ServerAccess server = land.getServerAccess();
        server.logout();
    }

    protected void updateGUI() {
        Land land = this.getSelectedLand();
        Land.Type type = land.getType();
        ServerAccess server = land.getServerAccess();
        boolean hasLoggedIn = server.hasLoggedIn();
        if (type != Land.Type.ACTIVE) {
            this.status.setText("\u3053\u306e\u56fd\u306f\u65e2\u306b\u6ec5\u3073\u307e\u3057\u305f\u3002\u30ed\u30b0\u30a4\u30f3\u306f\u7121\u610f\u5473\u3067\u3059");
            this.idField.setEnabled(false);
            this.pwField.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.logoutButton.setEnabled(false);
        } else if (hasLoggedIn) {
            this.status.setText("\u30e6\u30fc\u30b6 [ " + this.getUserID(land) + " ] \u3068\u3057\u3066" + "\u73fe\u5728\u30ed\u30b0\u30a4\u30f3\u4e2d\u3067\u3059");
            this.idField.setEnabled(false);
            this.pwField.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.logoutButton.setEnabled(true);
        } else {
            this.status.setText("\u73fe\u5728\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093");
            this.idField.setEnabled(true);
            this.pwField.setEnabled(true);
            this.loginButton.setEnabled(true);
            this.logoutButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (source == this.loginButton) {
            this.login();
        } else if (source == this.logoutButton) {
            this.logout();
        }
        this.updateGUI();
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source != this.landBox) {
            return;
        }
        Land land = (Land)event.getItem();
        switch (event.getStateChange()) {
            case 1: {
                String id = this.getUserID(land);
                char[] password = this.getPassword(land);
                this.idField.setText(id);
                this.pwField.setText(new String(password));
                this.updateGUI();
                break;
            }
            case 2: {
                String id = this.idField.getText();
                char[] password = this.pwField.getPassword();
                this.landUserIDMap.put(land, id);
                this.landPasswordMap.put(land, password);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
    }
}

