/*
 * Copyright 2007-2009 Jiemamy Project and the Others.
 * Created on 2009/02/25
 *
 * This file is part of Jiemamy.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.jiemamy.eclipse.composer;

import java.io.File;
import java.util.List;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

import org.jiemamy.composer.exporter.DefaultSqlExportConfig;
import org.jiemamy.composer.exporter.SqlExportConfig;
import org.jiemamy.composer.exporter.SqlExporter;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.ui.ExporterWizard;
import org.jiemamy.eclipse.ui.FileSelectWizardPage;
import org.jiemamy.eclipse.utils.EditorUtil;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.dataset.DataSetModel;
import org.jiemamy.utils.CollectionsUtil;

/**
 * {@link SqlExporter}の設定取得ウィザード。
 * 
 * @author daisuke
 */
public class SqlExportWizard extends Wizard implements ExporterWizard<SqlExporter, SqlExportConfig>, IWorkbenchWizard {
	
	private FileSelectWizardPage page1;
	
	private SqlExportWizardPage page2;
	
	private DefaultSqlExportConfig config;
	

	/**
	 * Creates a wizard for exporting SQL to the local file system.
	 */
	public SqlExportWizard() {
		IDialogSettings workbenchSettings = JiemamyUIPlugin.getDefault().getDialogSettings();
		IDialogSettings section = workbenchSettings.getSection("ExportWizard"); // $NON-NLS-1$
		if (section == null) {
			section = workbenchSettings.addNewSection("ExportWizard"); // $NON-NLS-1$
		}
		setDialogSettings(section);
	}
	
	@Override
	public void addPages() {
		IEditorPart activeEditor = EditorUtil.getActiveEditor();
		List<String> dataSetNames = CollectionsUtil.newArrayList();
		if (activeEditor instanceof JiemamyEditor) {
			JiemamyEditor jiemamyEditor = (JiemamyEditor) activeEditor;
			RootModel rootModel = jiemamyEditor.getRootModel();
			List<DataSetModel> dataSets = rootModel.getDataSets();
			for (DataSetModel dataSetModel : dataSets) {
				dataSetNames.add(dataSetModel.getName());
			}
		}
		super.addPages();
		
		// RESOURCE
		page1 = new FileSelectWizardPage("出力ファイル選択", "出力ファイル選択", (ImageDescriptor) null, new String[] {
			"SQLファイル(.sql)",
			"すべて"
		}, new String[] {
			"*.sql",
			"*.*"
		});
		addPage(page1);
		
		page2 = new SqlExportWizardPage(dataSetNames);
		addPage(page2);
	}
	
	public SqlExportConfig getConfig() {
		return config;
	}
	
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		setWindowTitle("SQLにエクスポート"); // RESOURCE
//		setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/exportdir_wiz.png"));
		setNeedsProgressMonitor(true);
	}
	
	@Override
	public boolean performFinish() {
		config = new DefaultSqlExportConfig();
		config.setOutputFile(new File(page1.getPath()));
		config.setOverwrite(page1.getOverwrite());
		config.setDataSetIndex(page2.getDataSetIndex());
		config.setEmitDropStatements(page2.getEmitDropStatements());
		config.setEmitCreateSchema(page2.getEmitCreateSchema());
		return true;
	}
	
	public void setInput(IFileEditorInput input) {
		// nothing to do
	}
	
}
