/*
 * Copyright 2007-2009 Jiemamy Project and the Others.
 * Created on 2009/03/19
 *
 * This file is part of Jiemamy.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.jiemamy.eclipse.dialect.mysql;

import org.apache.commons.lang.BooleanUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.jiemamy.dialect.mysql.adapter.Unsigned;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.TypeOptionHandler;
import org.jiemamy.eclipse.utils.SwtUtil;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DataTypeHolder;

/**
 * MySQL用の{@link TypeOptionHandler}実装クラス。
 * 
 * @author daisuke
 */
public class MySqlTypeOptionHandler implements TypeOptionHandler {
	
	private static Logger logger = LoggerFactory.getLogger(MySqlTypeOptionHandler.class);
	
	private Button chkUnsigned;
	
	private DataTypeHolder<? extends DataType> holder;
	

	public void createControl(DataTypeHolder<? extends DataType> holder, Composite composite, EditListener editListener) {
		logger.trace("createControl");
		this.holder = holder;
		
		DataType dataType = holder.getDataType();
		if (dataType instanceof BuiltinDataType) {
			BuiltinDataType builtinDataType = (BuiltinDataType) dataType;
			if (builtinDataType.hasAdapter(Unsigned.class)) {
				chkUnsigned = new Button(composite, SWT.CHECK);
				chkUnsigned.setText("UNSIGNED"); // RESOURCE
				chkUnsigned.addKeyListener(editListener);
			}
		}
	}
	
	public void disable() {
		logger.trace("disable");
		SwtUtil.setEnabledIfAlive(chkUnsigned, false);
	}
	
	public void enable() {
		logger.trace("enable");
		SwtUtil.setEnabledIfAlive(chkUnsigned, true);
	}
	
	public void setValue(Class<?> adapterClass) {
		logger.trace("setValue");
		DataType dataType = holder.getDataType();
		if ((dataType instanceof BuiltinDataType) == false) {
			return;
		}
		BuiltinDataType builtinDataType = (BuiltinDataType) dataType;
		
		if (Unsigned.class.isAssignableFrom(adapterClass)) {
			Unsigned unsigned = (Unsigned) builtinDataType.getAdapter(adapterClass);
			Boolean isUnsigned = unsigned.getUnsigned();
			chkUnsigned.setSelection(BooleanUtils.isTrue(isUnsigned));
		}
	}
	
	public void writeBackToAdapter() {
		logger.trace("writeBackToAdapter");
		DataType dataType = holder.getDataType();
		if ((dataType instanceof BuiltinDataType) == false) {
			return;
		}
		BuiltinDataType builtinDataType = (BuiltinDataType) dataType;
		
		if (SwtUtil.isAlive(chkUnsigned) && builtinDataType.hasAdapter(Unsigned.class)) {
			boolean value = chkUnsigned.getSelection();
			builtinDataType.getAdapter(Unsigned.class).setUnsigned(value == false ? null : value);
		}
	}
	
}
