/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.dialect.mysql;

import org.apache.commons.lang.BooleanUtils;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jiemamy.dialect.mysql.adapter.Unsigned;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.TypeOptionHandler;
import org.jiemamy.eclipse.utils.SwtUtil;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DataTypeHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlTypeOptionHandler
implements TypeOptionHandler {
    private static Logger logger = LoggerFactory.getLogger(MySqlTypeOptionHandler.class);
    private Button chkUnsigned;
    private DataTypeHolder<? extends DataType> holder;

    public void createControl(DataTypeHolder<? extends DataType> holder, Composite composite, EditListener editListener) {
        BuiltinDataType builtinDataType;
        logger.trace("createControl");
        this.holder = holder;
        DataType dataType = holder.getDataType();
        if (dataType instanceof BuiltinDataType && (builtinDataType = (BuiltinDataType)dataType).hasAdapter(Unsigned.class)) {
            this.chkUnsigned = new Button(composite, 32);
            this.chkUnsigned.setText("UNSIGNED");
            this.chkUnsigned.addKeyListener((KeyListener)editListener);
        }
    }

    public void disable() {
        logger.trace("disable");
        SwtUtil.setEnabledIfAlive((Control)this.chkUnsigned, (boolean)false);
    }

    public void enable() {
        logger.trace("enable");
        SwtUtil.setEnabledIfAlive((Control)this.chkUnsigned, (boolean)true);
    }

    public void setValue(Class<?> adapterClass) {
        logger.trace("setValue");
        DataType dataType = this.holder.getDataType();
        if (!(dataType instanceof BuiltinDataType)) {
            return;
        }
        BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
        if (Unsigned.class.isAssignableFrom(adapterClass)) {
            Unsigned unsigned = (Unsigned)builtinDataType.getAdapter(adapterClass);
            Boolean isUnsigned = unsigned.getUnsigned();
            this.chkUnsigned.setSelection(BooleanUtils.isTrue((Boolean)isUnsigned));
        }
    }

    public void writeBackToAdapter() {
        logger.trace("writeBackToAdapter");
        DataType dataType = this.holder.getDataType();
        if (!(dataType instanceof BuiltinDataType)) {
            return;
        }
        BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
        if (SwtUtil.isAlive((Control)this.chkUnsigned) && builtinDataType.hasAdapter(Unsigned.class)) {
            boolean value = this.chkUnsigned.getSelection();
            ((Unsigned)builtinDataType.getAdapter(Unsigned.class)).setUnsigned(!value ? null : Boolean.valueOf(value));
        }
    }
}

