/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.list.UnmodifiableList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.exception.IllegalImplementationException;
import org.jiemamy.utils.CollectionsUtil;
import org.seasar.eclipse.common.util.ExtensionAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionResolver<T> {
    private Map<String, IConfigurationElement> extensionConfigurationElements = CollectionsUtil.newHashMap();
    private List<T> allInstance;

    public ExtensionResolver(String pluginId, String extensionPointName, String extensionElementName) {
        this(pluginId, extensionPointName, extensionElementName, "id");
    }

    public ExtensionResolver(String pluginId, String extensionPointName, final String extensionElementName, final String identifierAttributeName) {
        ExtensionAcceptor.accept((String)pluginId, (String)extensionPointName, (ExtensionAcceptor.ExtensionVisitor)new ExtensionAcceptor.ExtensionVisitor(){

            public void visit(IConfigurationElement element) {
                if (extensionElementName.equals(element.getName())) {
                    ExtensionResolver.this.extensionConfigurationElements.put(element.getAttribute(identifierAttributeName), element);
                }
            }
        });
    }

    public List<T> getAllInstance() {
        return this.getAllInstance("class");
    }

    public List<T> getAllInstance(String classAttributeName) {
        if (this.allInstance == null) {
            ArrayList<T> result = new ArrayList<T>();
            for (String key : this.extensionConfigurationElements.keySet()) {
                try {
                    result.add(this.getInstance(key, classAttributeName));
                }
                catch (CoreException e) {
                    JiemamyCorePlugin plugin = JiemamyCorePlugin.getDefault();
                    String symbolicName = plugin.getBundle().getSymbolicName();
                    Status status = new Status(4, symbolicName, 0, "extension instantiation error.", (Throwable)e);
                    ILog log = plugin.getLog();
                    log.log((IStatus)status);
                }
            }
            this.allInstance = UnmodifiableList.decorate(result);
        }
        return this.allInstance;
    }

    public Map<String, IConfigurationElement> getExtensionConfigurationElements() {
        return this.extensionConfigurationElements;
    }

    public T getInstance(String identifier) throws CoreException {
        return this.getInstance(identifier, "class");
    }

    public T getInstance(String identifier, String classAttributeName) throws CoreException {
        Object instance;
        Object obj = this.extensionConfigurationElements.get(identifier).createExecutableExtension(classAttributeName);
        try {
            Object t;
            instance = t = obj;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalImplementationException(obj);
        }
        return (T)instance;
    }
}

