/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.jiemamy.Artemis;
import org.jiemamy.ArtemisExtender;
import org.jiemamy.ArtemisView;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyImplementation;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.eclipse.wizard.Messages;
import org.jiemamy.model.RootModel;

public final class NewDiagramWizard
extends Wizard
implements INewWizard {
    private NewDiagramWizardPage page;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public NewDiagramWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Jiemamy Database Diagram");
        IDialogSettings workbenchSettings = JiemamyUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewDiagramWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewDiagramWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.page = new NewDiagramWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    public boolean performFinish() {
        IFile file;
        block6: {
            if (this.page.getFileExtension() == null) {
                this.page.setFileExtension("jer");
            }
            if ((file = this.page.createNewFile()) != null) break block6;
            return false;
        }
        try {
            try {
                IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                ExceptionHandler.handleException(e);
                return false;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return true;
    }

    private static class NewDiagramWizardPage
    extends WizardNewFileCreationPage {
        public NewDiagramWizardPage(IStructuredSelection selection) {
            super("pageName", selection);
            this.setTitle(Messages.Wizard_Title);
            this.setMessage(Messages.Wizard_Message);
        }

        protected void createLinkTarget() {
        }

        protected InputStream getInitialContents() {
            Jiemamy jiemamy = Jiemamy.newInstance((JiemamyImplementation)new Artemis(new ArtemisExtender[]{new ArtemisView()}));
            RootModel rootModel = jiemamy.getFactory().getRootModel();
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                jiemamy.getSerializer().serialize(rootModel, (OutputStream)out);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
                return null;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }

        protected boolean validatePage() {
            if (this.getFileExtension() == null) {
                this.setFileExtension("jer");
            }
            if (!this.getFileExtension().equals("jer")) {
                return false;
            }
            return super.validatePage();
        }
    }
}

