/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.utils;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.jiemamy.eclipse.utils.ExceptionHandler;

public final class MarkerUtil {
    public static final String MARKER_ID = "org.jiemamy.eclipse.ui.problem";

    public static void createMarker(IResource resource, int priority, int severity, String message) {
        if (resource == null) {
            return;
        }
        try {
            IMarker marker = resource.createMarker(MARKER_ID);
            HashMap<String, Object> attributes = new HashMap<String, Object>(3);
            attributes.put("priority", priority);
            attributes.put("severity", severity);
            attributes.put("message", message);
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            ExceptionHandler.handleException((Throwable)e, 14);
        }
    }

    public static void deleteAllMarkers() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        MarkerUtil.deleteMarker((IResource)root);
    }

    public static void deleteMarker(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            ExceptionHandler.handleException((Throwable)e, 14);
        }
    }

    public static void deleteMarkers(IResource resource) {
        IMarker[] iMarkerArray = MarkerUtil.findMarker(resource);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                marker.delete();
            }
            catch (CoreException e) {
                ExceptionHandler.handleException((Throwable)e, 14);
            }
            ++n2;
        }
    }

    public static IMarker[] findMarker(IResource resource) {
        if (resource == null) {
            return new IMarker[0];
        }
        try {
            return resource.findMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            ExceptionHandler.handleException((Throwable)e, 14);
            return new IMarker[0];
        }
    }

    private MarkerUtil() {
    }
}

