/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.seasar.eclipse.common.util.LogUtil;
import org.seasar.eclipse.common.util.StatusUtil;

public final class ExceptionHandler {
    public static final int LOG = 2;
    public static final int DIALOG = 4;
    public static final int STACKTRACE = 8;
    public static final int ALL = 14;
    private static Plugin plugin = JiemamyUIPlugin.getDefault();

    public static void handleException(Throwable e) {
        ExceptionHandler.handleException(e, 14, "Exception is thrown: " + e.getClass().getCanonicalName());
    }

    public static void handleException(Throwable e, int operation) {
        ExceptionHandler.handleException(e, operation, "Exception is thrown: " + e.getClass().getCanonicalName());
    }

    public static void handleException(Throwable e, int operation, String message) {
        IStatus status = StatusUtil.createInfo((Plugin)plugin, (int)1, (String)message, null);
        if ((operation & 2) != 0) {
            LogUtil.log((Plugin)plugin, (String)message);
        }
        if ((operation & 4) != 0) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ErrorDialog.openError((Shell)window.getShell(), (String)message, (String)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (IStatus)status);
        }
        if ((operation & 8) != 0) {
            e.printStackTrace();
        }
    }

    public static void handleException(Throwable e, String message) {
        ExceptionHandler.handleException(e, 14, message);
    }

    private ExceptionHandler() {
    }
}

