/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.ui;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.extension.ExtensionResolver;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JiemamyEditDialog<T extends JiemamyElement>
extends Dialog {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private T targetModel;
    private List<AbstractTab> tabs = CollectionsUtil.newArrayList();
    private final Class<? extends JiemamyElement> type;
    protected final EditListener editListener = new EditListenerImpl();

    protected JiemamyEditDialog(Shell parentShell, T targetModel, Class<? extends JiemamyElement> type) {
        super(parentShell);
        Validate.notNull(targetModel);
        Validate.notNull(type);
        this.targetModel = targetModel;
        this.type = type;
        this.readConfiguration();
    }

    public boolean close() {
        Shell shell = this.getShell();
        Point location = shell.getLocation();
        Point size = shell.getSize();
        boolean closed = super.close();
        if (closed) {
            this.writeConfiguration(size, location);
        }
        return closed;
    }

    public List<AbstractTab> getTabs() {
        return this.tabs;
    }

    protected void addTab(AbstractTab tab) {
        this.tabs.add(tab);
    }

    protected boolean canExecuteOk() {
        for (AbstractTab tab : this.tabs) {
            if (tab.isTabComplete()) continue;
            return false;
        }
        return true;
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        Shell shell = this.getShell();
        if (this.dialogLocation != null) {
            shell.setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            shell.setSize(this.dialogSize);
        } else {
            shell.setSize(this.getDefaultSize());
        }
    }

    protected AbstractTab createAdditionalTab(TabFolder tabFolder, String tabClassName) {
        AbstractTab tab = null;
        try {
            Class<?> tabClass = Class.forName(tabClassName);
            Constructor<?> constructor = tabClass.getConstructor(TabFolder.class, Integer.TYPE, this.type);
            tab = (AbstractTab)((Object)constructor.newInstance(tabFolder, 0, this.targetModel));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return tab;
    }

    protected List<AbstractTab> createAdditionalTabs(TabFolder tabFolder) {
        ArrayList result = CollectionsUtil.newArrayList();
        ExtensionResolver dialectResolver = JiemamyCorePlugin.getDialectResolver();
        RootModel rootModel = this.targetModel.getJiemamy().getFactory().getRootModel();
        IConfigurationElement dialectElement = (IConfigurationElement)dialectResolver.getExtensionConfigurationElements().get(rootModel.getDialectClassName());
        IConfigurationElement[] iConfigurationElementArray = dialectElement.getChildren("additionalTab");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tabClassName;
            AbstractTab tab;
            IConfigurationElement additionalTabElement = iConfigurationElementArray[n2];
            if (additionalTabElement.getAttribute("target").equals(((Object)((Object)this)).getClass().getName()) && (tab = this.createAdditionalTab(tabFolder, tabClassName = additionalTabElement.getAttribute("class"))) != null) {
                result.add(tab);
                this.addTab(tab);
            }
            ++n2;
        }
        return result;
    }

    protected abstract Point getDefaultSize();

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = JiemamyUIPlugin.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    protected T getTargetModel() {
        return this.targetModel;
    }

    protected void okPressed() {
        if (!this.canExecuteOk()) {
            return;
        }
        if (this.performOk()) {
            for (AbstractTab tab : this.tabs) {
                tab.okPressed();
            }
            super.okPressed();
        }
    }

    protected abstract boolean performOk();

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt(X);
            int y = s.getInt(Y);
            this.dialogLocation = new Point(x, y);
            x = s.getInt(WIDTH);
            y = s.getInt(HEIGHT);
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration(Point size, Point location) {
        IDialogSettings s = this.getDialogSettings();
        s.put(X, location.x);
        s.put(Y, location.y);
        s.put(WIDTH, size.x);
        s.put(HEIGHT, size.y);
    }

    public class EditListenerImpl
    extends AbstractEditListener {
        protected void process(TypedEvent e) {
            JiemamyEditDialog.this.getButton(0).setEnabled(JiemamyEditDialog.this.canExecuteOk());
        }
    }
}

