/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jiemamy.eclipse.ui.TableEditorConfig;

public abstract class AbstractTableEditor
extends Composite {
    private final TableViewer tableViewer;
    private Button btnAdd;
    private Button btnInsert;
    private Button btnRemove;
    private Button btnMoveUp;
    private Button btnMoveDown;

    public AbstractTableEditor(Composite parent, int style, TableEditorConfig config) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(1808));
        this.tableViewer = new TableViewer((Composite)this, 68352);
        Composite cmpButtons = new Composite((Composite)this, 0);
        cmpButtons.setLayout((Layout)new RowLayout());
        cmpButtons.setLayoutData((Object)new GridData());
        if (config.getAddLabel() != null) {
            this.btnAdd = new Button(cmpButtons, 8);
            this.btnAdd.setText(config.getAddLabel());
        }
        if (config.getInsertLabel() != null) {
            this.btnInsert = new Button(cmpButtons, 8);
            this.btnInsert.setText(config.getInsertLabel());
        }
        if (config.getRemoveLabel() != null) {
            this.btnRemove = new Button(cmpButtons, 8);
            this.btnRemove.setText(config.getRemoveLabel());
        }
        this.createOptionalEditButtons(cmpButtons);
        this.btnMoveUp = new Button(cmpButtons, 132);
        this.btnMoveDown = new Button(cmpButtons, 1028);
        Group grpEditor = new Group((Composite)this, 0);
        grpEditor.setLayoutData((Object)new GridData(768));
        grpEditor.setLayout((Layout)new GridLayout(1, false));
        grpEditor.setText(config.getEditorTitle());
        this.createEditorControls((Composite)grpEditor);
        assert (this.tableViewer != null);
    }

    public void configure() {
        this.configureTable(this.tableViewer.getTable());
        this.configureTableViewer(this.tableViewer);
        this.createTableColumns(this.tableViewer.getTable());
        this.configureCellEditor();
        this.configureEditButtons();
        this.configureEditorControls();
        this.refreshTable();
    }

    public void disableEditControls() {
        this.disableEditButtons();
        this.disableEditorControls();
    }

    public void enableEditControls(int index) {
        this.enableEditButtons(index);
        this.enableEditorControls(index);
    }

    public Button getBtnAdd() {
        return this.btnAdd;
    }

    public final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public final void refreshTable() {
        this.tableViewer.refresh();
    }

    public void refreshTableColumns() {
        this.removeTableColumns(this.tableViewer.getTable());
        this.createTableColumns(this.tableViewer.getTable());
        this.refreshTable();
    }

    protected void configureCellEditor() {
    }

    protected void configureEditButtons() {
        if (this.btnAdd != null) {
            this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.performAddItem();
                }
            });
        }
        if (this.btnInsert != null) {
            this.btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.performInsertItem();
                }
            });
        }
        if (this.btnRemove != null) {
            this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.performRemoveItem();
                }
            });
        }
        if (this.btnMoveUp != null) {
            this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.performMoveUpItem();
                }
            });
        }
        if (this.btnMoveDown != null) {
            this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.performMoveDownItem();
                }
            });
        }
    }

    protected void configureEditorControls() {
    }

    protected void configureTable(final Table table) {
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = table.getSelectionIndex();
                if (index >= 0) {
                    AbstractTableEditor.this.enableEditControls(index);
                } else {
                    AbstractTableEditor.this.disableEditControls();
                }
            }
        });
    }

    protected abstract void configureTableViewer(TableViewer var1);

    protected abstract void createEditorControls(Composite var1);

    protected void createOptionalEditButtons(Composite cmpButtons) {
    }

    protected abstract void createTableColumns(Table var1);

    protected void disableEditButtons() {
        if (this.btnInsert != null) {
            this.btnInsert.setEnabled(false);
        }
        if (this.btnRemove != null) {
            this.btnRemove.setEnabled(false);
        }
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
    }

    protected void disableEditorControls() {
    }

    protected void enableEditButtons(int index) {
        if (this.btnInsert != null) {
            this.btnInsert.setEnabled(true);
        }
        if (this.btnRemove != null) {
            this.btnRemove.setEnabled(true);
        }
        this.btnMoveUp.setEnabled(true);
        this.btnMoveDown.setEnabled(true);
        if (index <= 0) {
            this.btnMoveUp.setEnabled(false);
        }
        if (index >= this.tableViewer.getTable().getItemCount() - 1) {
            this.btnMoveDown.setEnabled(false);
        }
    }

    protected void enableEditorControls(int index) {
    }

    protected abstract Object performAddItem();

    protected abstract Object performInsertItem();

    protected abstract void performMoveDownItem();

    protected abstract void performMoveUpItem();

    protected abstract Object performRemoveItem();

    private void removeTableColumns(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.dispose();
            ++n2;
        }
    }
}

