/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.preference;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.jiemamy.eclipse.preference.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConnectionRouters {
    BENDPOINT(Messages.Bendpoint_Connection_Router){

        public ConnectionRouter getRouter(IFigure figure) {
            FanRouter fanRouter = ConnectionRouters.getFanRouter();
            fanRouter.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            return fanRouter;
        }
    }
    ,
    SHORTEST(Messages.Shortest_Path_Connection_Router){

        public ConnectionRouter getRouter(IFigure figure) {
            FanRouter fanRouter = ConnectionRouters.getFanRouter();
            fanRouter.setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter(figure));
            return fanRouter;
        }
    }
    ,
    MANHATTAN(Messages.Manhattan_Connection_Router){

        public ConnectionRouter getRouter(IFigure figure) {
            return new ManhattanConnectionRouter();
        }
    };

    private static final int FAN_ROUTER_SEPARATION = 50;
    private static final String[] LABELS;
    private String label;

    static {
        LABELS = new String[ConnectionRouters.values().length];
        int count = 0;
        ConnectionRouters[] connectionRoutersArray = ConnectionRouters.values();
        int n = connectionRoutersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionRouters router = connectionRoutersArray[n2];
            ConnectionRouters.LABELS[count++] = router.label;
            ++n2;
        }
    }

    public static ConnectionRouters get(String label) {
        ConnectionRouters[] connectionRoutersArray = ConnectionRouters.values();
        int n = connectionRoutersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionRouters router = connectionRoutersArray[n2];
            if (router.label.equals(label)) {
                return router;
            }
            ++n2;
        }
        throw new IllegalArgumentException(label);
    }

    public static String[] getLabels() {
        return (String[])LABELS.clone();
    }

    private static FanRouter getFanRouter() {
        FanRouter fanRouter = new FanRouter();
        fanRouter.setSeparation(50);
        return fanRouter;
    }

    private ConnectionRouters(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract ConnectionRouter getRouter(IFigure var1);

    /* synthetic */ ConnectionRouters(String string, int n, String string2, ConnectionRouters connectionRouters) {
        this(string2);
    }
}

