/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.utils;

import java.util.List;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.formatter.DefaultSqlFormatter;
import org.jiemamy.internal.model.sql.Separator;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.attribute.constraint.KeyConstraint;
import org.jiemamy.model.attribute.constraint.PrimaryKey;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DomainModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.sql.Token;
import org.jiemamy.utils.model.KeyConstraintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelStringUtil {
    private static Logger logger = LoggerFactory.getLogger(LabelStringUtil.class);

    public static String getString(RootModel rootModel, DataType dataType, DisplayPlace place) {
        ReferenceResolver resolver = rootModel.getJiemamy().getReferenceResolver();
        try {
            Dialect dialect = rootModel.findDialect();
            List tokens = dialect.getDataTypeResolver().resolveDataType(dataType, resolver);
            StringBuilder sb = new StringBuilder();
            Object lastToken = null;
            for (Token token : tokens) {
                if (!DefaultSqlFormatter.isSeparator(lastToken) && !DefaultSqlFormatter.isSeparator((Token)token) || lastToken == null || lastToken.equals(Separator.COMMA)) {
                    sb.append(" ");
                }
                sb.append(token);
                lastToken = token;
            }
            return sb.toString();
        }
        catch (ClassNotFoundException e) {
            logger.warn("Dialect\u306e\u30ed\u30b9\u30c8", (Throwable)e);
            return dataType.toBuiltinDataType(resolver).getTypeName();
        }
    }

    public static String getString(RootModel rootModel, JiemamyElement targetElement, DisplayPlace place) {
        if (targetElement instanceof DomainModel) {
            DomainModel domainModel = (DomainModel)targetElement;
            return domainModel.getName();
        }
        if (targetElement instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)targetElement;
            return entityModel.getName();
        }
        if (targetElement instanceof ColumnModel) {
            ColumnModel columnModel = (ColumnModel)targetElement;
            return columnModel.getName();
        }
        if (targetElement instanceof PrimaryKey) {
            PrimaryKey primaryKey = (PrimaryKey)targetElement;
            StringBuilder sb = new StringBuilder("PK ");
            if (primaryKey.getName() != null) {
                sb.append(" ");
                sb.append(primaryKey.getName());
            }
            sb.append("(");
            sb.append(KeyConstraintUtil.toStringKeyColumns((KeyConstraint)primaryKey));
            sb.append(")");
            return sb.toString();
        }
        if (targetElement instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)targetElement;
            ReferenceResolver resolver = rootModel.getJiemamy().getReferenceResolver();
            StringBuilder sb = new StringBuilder();
            if (foreignKey.getName() != null) {
                sb.append(foreignKey.getName()).append("\n");
            }
            int size = Math.max(foreignKey.getReferenceColumns().size(), foreignKey.getKeyColumns().size());
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append("\n");
                }
                if (foreignKey.getKeyColumns().size() > i) {
                    ColumnRef keyColumnRef = (ColumnRef)foreignKey.getKeyColumns().get(i);
                    ColumnModel keyColumn = (ColumnModel)resolver.resolve((ElementReference)keyColumnRef);
                    sb.append(keyColumn.getName());
                } else {
                    sb.append("UNKNOWN");
                }
                sb.append(" -> ");
                if (foreignKey.getReferenceColumns().size() > i) {
                    ColumnRef referenceColumnRef = (ColumnRef)foreignKey.getReferenceColumns().get(i);
                    ColumnModel referenceColumn = (ColumnModel)resolver.resolve((ElementReference)referenceColumnRef);
                    sb.append(referenceColumn.getName());
                } else {
                    sb.append("UNKNOWN");
                }
                ++i;
            }
            return sb.toString();
        }
        return "unknown label: " + targetElement.getClass().getName();
    }

    private LabelStringUtil() {
    }
}

