/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.figure.ColumnFigure;
import org.jiemamy.eclipse.editor.figure.EntityFigure;
import org.jiemamy.eclipse.utils.SwtColorUtil;

public class ViewFigure
extends EntityFigure {
    private static final Color DEFAULT = new Color(null, 240, 250, 255);

    public ViewFigure() {
        super(DEFAULT);
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        this.getEntityNameLabel().setIcon(ir.get("LABEL_VIEW"));
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setBackgroundColor(this.getDefaultColor());
        this.setOpaque(true);
        this.add((IFigure)this.getEntityNameLabel());
        this.add((IFigure)this.getColumnFigure());
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof ColumnFigure) {
            this.getColumnFigure().add(figure);
        } else {
            super.add(figure, constraint, index);
        }
    }

    public void remove(IFigure figure) {
        if (figure instanceof ColumnFigure) {
            this.getColumnFigure().remove(figure);
        } else {
            super.remove(figure);
        }
    }

    public void removeAllColumns() {
        this.getColumnFigure().removeAll();
    }

    public void setBgColor(Color bgColor) {
        super.setBgColor(bgColor);
        if (SwtColorUtil.isDarkColor(this.getBackgroundColor())) {
            this.setForegroundColor(ColorConstants.white);
        } else {
            this.setForegroundColor(ColorConstants.black);
        }
    }
}

