/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.figure.ColumnFigure;
import org.jiemamy.eclipse.editor.figure.CompartmentFigure;
import org.jiemamy.eclipse.editor.figure.CompartmentFigureBorder;
import org.jiemamy.eclipse.editor.figure.EntityFigure;
import org.jiemamy.eclipse.utils.SwtColorUtil;

public class TableFigure
extends EntityFigure {
    private ColumnLayoutFigure columnFigure = new ColumnLayoutFigure();
    private CompartmentFigure columnNameFigure = new CompartmentFigure();
    private CompartmentFigure columnTypeFigure = new CompartmentFigure();

    public TableFigure() {
        super(ColorConstants.tooltipBackground);
        Label entityNameLabel = this.getEntityNameLabel();
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        entityNameLabel.setIcon(ir.get("LABEL_TABLE"));
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setBackgroundColor(this.getDefaultColor());
        this.setOpaque(true);
        this.add((IFigure)entityNameLabel);
        this.add((IFigure)this.columnFigure);
        this.columnFigure.add((IFigure)this.columnNameFigure);
        this.columnFigure.add((IFigure)this.columnTypeFigure);
    }

    public void add(ColumnFigure nameFigure, ColumnFigure typeFigure) {
        this.columnNameFigure.add((IFigure)nameFigure);
        this.columnTypeFigure.add((IFigure)typeFigure);
    }

    public void remove(IFigure figure) {
        if (figure instanceof ColumnFigure) {
            this.columnNameFigure.remove(figure);
            this.columnTypeFigure.remove(figure);
        } else {
            super.remove(figure);
        }
    }

    public void removeAllColumns() {
        this.columnNameFigure.removeAll();
        this.columnTypeFigure.removeAll();
    }

    public void setBgColor(Color bgColor) {
        super.setBgColor(bgColor);
        if (SwtColorUtil.isDarkColor(this.getBackgroundColor())) {
            this.columnNameFigure.setForegroundColor(ColorConstants.white);
            this.columnTypeFigure.setForegroundColor(ColorConstants.white);
        } else {
            this.columnNameFigure.setForegroundColor(ColorConstants.black);
            this.columnTypeFigure.setForegroundColor(ColorConstants.black);
        }
    }

    public void setTableName(String tableName) {
        this.getEntityNameLabel().setText(tableName);
    }

    private static class ColumnLayoutFigure
    extends Figure {
        public ColumnLayoutFigure() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new CompartmentFigureBorder());
        }
    }
}

