/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.jiemamy.eclipse.utils.SwtColorUtil;

public class StickyFigure
extends RoundedRectangle {
    private static final Color DEFAULT = new Color(null, 255, 230, 230);
    private Label contentsLabel;

    public StickyFigure() {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.contentsLabel = new Label();
        this.setBorder((Border)new MarginBorder(5));
        this.setCornerDimensions(new Dimension(16, 16));
        this.add((IFigure)this.contentsLabel, BorderLayout.CENTER);
    }

    public Label getContentsLabel() {
        return this.contentsLabel;
    }

    public void setBgColor(Color bgColor) {
        this.setBackgroundColor(bgColor == null ? DEFAULT : bgColor);
        if (SwtColorUtil.isDarkColor(this.getBackgroundColor())) {
            this.setForegroundColor(ColorConstants.white);
        } else {
            this.setForegroundColor(ColorConstants.black);
        }
    }

    public void setContents(String contents) {
        this.contentsLabel.setText(contents);
    }

    protected void outlineShape(Graphics graphics) {
        super.outlineShape(graphics);
        Rectangle f = Rectangle.SINGLETON;
        Rectangle r = this.getBounds();
        f.x = r.x + this.lineWidth / 2;
        f.y = r.y + this.lineWidth / 2;
        f.width = 16;
        f.height = 16;
    }
}

