/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Color;
import org.jiemamy.eclipse.editor.figure.CompartmentFigure;
import org.jiemamy.eclipse.editor.figure.CompartmentFigureBorder;
import org.jiemamy.eclipse.utils.SwtColorUtil;

public class EntityFigure
extends Figure {
    private Label entityNameLabel = new Label();
    private CompartmentFigure columnFigure;
    private Color defaultColor;

    public EntityFigure(Color defaultColor) {
        this.entityNameLabel.setBorder((Border)new MarginBorder(2, 2, 0, 2));
        this.columnFigure = new CompartmentFigure();
        this.columnFigure.setBorder((Border)new CompartmentFigureBorder());
        this.defaultColor = defaultColor;
    }

    public CompartmentFigure getColumnFigure() {
        return this.columnFigure;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public Label getEntityNameLabel() {
        return this.entityNameLabel;
    }

    public void setBgColor(Color bgColor) {
        this.setBackgroundColor(bgColor == null ? this.defaultColor : bgColor);
        if (SwtColorUtil.isDarkColor(this.getBackgroundColor())) {
            this.entityNameLabel.setForegroundColor(ColorConstants.white);
            this.columnFigure.setForegroundColor(ColorConstants.white);
        } else {
            this.entityNameLabel.setForegroundColor(ColorConstants.black);
            this.columnFigure.setForegroundColor(ColorConstants.black);
        }
    }

    public void setEntityName(String entityName) {
        this.entityNameLabel.setText(entityName);
    }
}

