/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpolicy;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.jiemamy.eclipse.editor.command.CreateBendpointCommand;
import org.jiemamy.eclipse.editor.command.DeleteBendpointCommand;
import org.jiemamy.eclipse.editor.command.MoveBendpointCommand;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.connection.ConnectionAdapter;

public class JmBendpointEditPolicy
extends BendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        Point point = request.getLocation();
        this.getConnection().translateToRelative((Translatable)point);
        ConnectionAdapter connection = (ConnectionAdapter)this.getHost().getModel();
        ForeignKey foreignKey = connection.unwrap();
        RootModel rootModel = foreignKey.getJiemamy().getFactory().getRootModel();
        return new CreateBendpointCommand(rootModel, 0, connection, point, request.getIndex());
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        ConnectionAdapter connection = (ConnectionAdapter)this.getHost().getModel();
        ForeignKey foreignKey = connection.unwrap();
        RootModel rootModel = foreignKey.getJiemamy().getFactory().getRootModel();
        return new DeleteBendpointCommand(rootModel, 0, connection, request.getIndex());
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        RootModel rootModel = (RootModel)this.getHost().getRoot().getContents().getModel();
        Point location = request.getLocation();
        this.getConnection().translateToRelative((Translatable)location);
        ConnectionAdapter connection = (ConnectionAdapter)this.getHost().getModel();
        return new MoveBendpointCommand(rootModel, 0, connection, request.getIndex(), location);
    }
}

