/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.outlinetree;

import org.apache.commons.lang.Validate;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.view.ViewEditDialog;
import org.jiemamy.eclipse.editor.editpart.outlinetree.AbstractEntityTreeEditPart;
import org.jiemamy.eclipse.editor.editpolicy.JmTreeComponentEditPolicy;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ViewTreeEditPart
extends AbstractEntityTreeEditPart {
    private static Logger logger = LoggerFactory.getLogger(ViewTreeEditPart.class);

    public ViewTreeEditPart(ViewModel viewModel) {
        Validate.notNull((Object)viewModel);
        this.setModel(viewModel);
    }

    public ViewModel getModel() {
        return (ViewModel)super.getModel();
    }

    public JiemamyElement getTargetModel() {
        ViewModel model = this.getModel();
        return model;
    }

    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getParent().getModel();
        ViewModel viewModel = this.getModel();
        JiemamyViewFacade facade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        Shell shell = this.getViewer().getControl().getShell();
        ViewEditDialog dialog = new ViewEditDialog(shell, viewModel, 0, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand((JiemamyFacade)facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    public void setModel(Object model) {
        if (!(model instanceof ViewModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new JmTreeComponentEditPolicy());
    }

    protected void refreshVisuals() {
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        ViewModel model = this.getModel();
        this.setWidgetText(LabelStringUtil.getString(rootModel, (JiemamyElement)model, DisplayPlace.OUTLINE_TREE));
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        this.setWidgetImage(ir.get("ICON_VIEW"));
    }
}

