/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.outlinetree;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialog;
import org.jiemamy.eclipse.editor.editpart.outlinetree.AbstractEntityTreeEditPart;
import org.jiemamy.eclipse.editor.editpolicy.JmTreeComponentEditPolicy;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.AttributeModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTreeEditPart
extends AbstractEntityTreeEditPart {
    private static Logger logger = LoggerFactory.getLogger(TableTreeEditPart.class);

    public TableTreeEditPart(TableModel tableModel) {
        Validate.notNull((Object)tableModel);
        this.setModel(tableModel);
    }

    public TableModel getModel() {
        return (TableModel)super.getModel();
    }

    public JiemamyElement getTargetModel() {
        TableModel model = this.getModel();
        return model;
    }

    @Override
    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getParent().getModel();
        TableModel tableModel = this.getModel();
        JiemamyViewFacade facade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        Shell shell = this.getViewer().getControl().getShell();
        TableEditDialog dialog = new TableEditDialog(shell, tableModel, 0, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand((JiemamyFacade)facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    public void setModel(Object model) {
        if (!(model instanceof TableModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new JmTreeComponentEditPolicy());
    }

    protected List<AttributeModel> getModelChildren() {
        TableModel tableModel = this.getModel();
        return tableModel.getAttributes();
    }

    protected void refreshVisuals() {
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        TableModel model = this.getModel();
        this.setWidgetText(LabelStringUtil.getString(rootModel, (JiemamyElement)model, DisplayPlace.OUTLINE_TREE));
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        this.setWidgetImage(ir.get("ICON_TABLE"));
    }
}

