/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.outlinetree;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.Jiemamy;
import org.jiemamy.eclipse.editor.ModelContainer;
import org.jiemamy.eclipse.editor.editpart.outlinetree.AbstractModelTreeEditPart;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.datatype.DomainModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootTreeEditPart
extends AbstractModelTreeEditPart {
    public static final String CONTAINER_DOMAIN = "org.jiemamy.eclipse.ui.container.domain";
    public static final String CONTAINER_TABLE = "org.jiemamy.eclipse.ui.container.table";
    public static final String CONTAINER_VIEW = "org.jiemamy.eclipse.ui.container.view";
    private static Logger logger = LoggerFactory.getLogger(RootTreeEditPart.class);
    private List<ModelContainer> children = CollectionsUtil.newArrayList();
    private ModelContainer domainContainer;
    private ModelContainer tableContainer;
    private ModelContainer viewContainer;

    public RootTreeEditPart(RootModel rootModel) {
        Validate.notNull((Object)rootModel);
        this.setModel(rootModel);
    }

    @Override
    public void activate() {
        logger.trace((Marker)LogMarker.LIFECYCLE, "activate");
        super.activate();
    }

    @Override
    public void deactivate() {
        logger.trace((Marker)LogMarker.LIFECYCLE, "deactivate");
        super.deactivate();
    }

    public RootModel getModel() {
        return (RootModel)super.getModel();
    }

    public JiemamyElement getTargetModel() {
        RootModel rootModel = this.getModel();
        return rootModel;
    }

    public void setModel(Object model) {
        if (!(model instanceof RootModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
        RootModel rootModel = this.getModel();
        Jiemamy jiemamy = rootModel.getJiemamy();
        this.domainContainer = new ModelContainer(CONTAINER_DOMAIN, "\u30c9\u30e1\u30a4\u30f3", jiemamy);
        this.tableContainer = new ModelContainer(CONTAINER_TABLE, "\u30c6\u30fc\u30d6\u30eb", jiemamy);
        this.viewContainer = new ModelContainer(CONTAINER_VIEW, "\u30d3\u30e5\u30fc", jiemamy);
        this.children.add(this.tableContainer);
        this.children.add(this.viewContainer);
        this.children.add(this.domainContainer);
    }

    protected List<? extends JiemamyElement> getModelChildren() {
        logger.trace((Marker)LogMarker.LIFECYCLE, "getModelChildren");
        RootModel rootModel = this.getModel();
        this.domainContainer.getChildren().clear();
        this.tableContainer.getChildren().clear();
        this.viewContainer.getChildren().clear();
        for (DomainModel domainModel : rootModel.getDomains()) {
            this.domainContainer.getChildren().add(domainModel);
        }
        for (EntityModel entityModel : rootModel.getEntities()) {
            if (entityModel instanceof TableModel) {
                this.tableContainer.getChildren().add(entityModel);
                continue;
            }
            if (entityModel instanceof ViewModel) {
                this.viewContainer.getChildren().add(entityModel);
                continue;
            }
            logger.warn("unknown entity: " + entityModel.getClass().getName());
        }
        return this.children;
    }
}

