/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.view.ViewEditDialog;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractEntityNodeEditPart;
import org.jiemamy.eclipse.editor.figure.ViewFigure;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.model.geometory.JmColor;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ViewEditPart
extends AbstractEntityNodeEditPart {
    private static Logger logger = LoggerFactory.getLogger(ViewEditPart.class);

    public ViewEditPart(NodeAdapter nodeAdapter) {
        super(nodeAdapter);
    }

    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getParent().getModel();
        NodeAdapter node = this.getModel();
        ViewModel viewModel = (ViewModel)node.unwrap();
        JiemamyViewFacade facade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        Shell shell = this.getViewer().getControl().getShell();
        ViewEditDialog dialog = new ViewEditDialog(shell, viewModel, 0, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand((JiemamyFacade)facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    protected IFigure createFigure() {
        ViewFigure figure = new ViewFigure();
        NodeAdapter node = this.getModel();
        ViewModel viewModel = (ViewModel)node.unwrap();
        String definition = viewModel.getDefinition();
        if (!StringUtils.isEmpty((String)definition)) {
            Panel tooltip = new Panel();
            tooltip.setLayoutManager((LayoutManager)new StackLayout());
            tooltip.setBackgroundColor(ColorConstants.tooltipBackground);
            tooltip.add((IFigure)new Label(definition));
            figure.setToolTip((IFigure)tooltip);
        }
        this.updateFigure((IFigure)figure);
        return figure;
    }

    protected void updateFigure(IFigure figure) {
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        NodeAdapter node = this.getModel();
        ViewModel viewModel = (ViewModel)node.unwrap();
        ViewFigure viewFigure = (ViewFigure)figure;
        String labelString = LabelStringUtil.getString(rootModel, (JiemamyElement)viewModel, DisplayPlace.FIGURE);
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(node);
        viewFigure.setEntityName(labelString);
        if (nodeProfile == null) {
            viewFigure.setBgColor(null);
        } else {
            JmColor color = nodeProfile.getColor();
            viewFigure.setBgColor(ConvertUtil.convert(color));
        }
        viewFigure.removeAllColumns();
    }
}

