/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialog;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractEntityNodeEditPart;
import org.jiemamy.eclipse.editor.figure.ColumnFigure;
import org.jiemamy.eclipse.editor.figure.TableFigure;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.Level;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.geometory.JmColor;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class TableEditPart
extends AbstractEntityNodeEditPart {
    private static Logger logger = LoggerFactory.getLogger(TableEditPart.class);

    public TableEditPart(NodeAdapter nodeAdapter) {
        super(nodeAdapter);
    }

    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getParent().getModel();
        NodeAdapter node = this.getModel();
        TableModel tableModel = (TableModel)node.unwrap();
        JiemamyViewFacade facade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        Shell shell = this.getViewer().getControl().getShell();
        TableEditDialog dialog = new TableEditDialog(shell, tableModel, 0, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand((JiemamyFacade)facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    public void refresh() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "refresh");
        super.refresh();
    }

    protected IFigure createFigure() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "createFigure");
        TableFigure figure = new TableFigure();
        NodeAdapter node = this.getModel();
        String description = ((TableModel)node.unwrap()).getDescription();
        if (!StringUtils.isEmpty((String)description)) {
            Panel tooltip = new Panel();
            tooltip.setLayoutManager((LayoutManager)new StackLayout());
            tooltip.setBackgroundColor(ColorConstants.tooltipBackground);
            tooltip.add((IFigure)new Label(description));
            figure.setToolTip((IFigure)tooltip);
        }
        this.updateFigure((IFigure)figure);
        return figure;
    }

    protected void updateFigure(IFigure figure) {
        logger.debug((Marker)LogMarker.LIFECYCLE, "updateFigure");
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        NodeAdapter node = this.getModel();
        TableModel tableModel = (TableModel)node.unwrap();
        TableFigure tableFigure = (TableFigure)figure;
        String labelString = LabelStringUtil.getString(rootModel, (JiemamyElement)tableModel, DisplayPlace.FIGURE);
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(node);
        tableFigure.setTableName(labelString);
        if (nodeProfile == null) {
            tableFigure.setBgColor(null);
        } else {
            JmColor color = nodeProfile.getColor();
            tableFigure.setBgColor(ConvertUtil.convert(color));
        }
        tableFigure.removeAllColumns();
        for (ColumnModel columnModel : tableModel.findColumns()) {
            ColumnFigure[] columnFigure = this.createColumnFigure(columnModel);
            tableFigure.add(columnFigure[0], columnFigure[1]);
        }
    }

    private ColumnFigure[] createColumnFigure(ColumnModel columnModel) {
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        if (presentation.getLevel() == Level.ENTITY) {
            return new ColumnFigure[0];
        }
        ColumnFigure nameLabel = new ColumnFigure();
        ColumnFigure typeLabel = new ColumnFigure();
        nameLabel.setText(LabelStringUtil.getString(rootModel, (JiemamyElement)columnModel, DisplayPlace.FIGURE));
        typeLabel.setText(LabelStringUtil.getString(rootModel, columnModel.getDataType(), DisplayPlace.FIGURE));
        if (columnModel.checkPrimaryKeyColumn()) {
            nameLabel.setUnderline(true);
            typeLabel.setUnderline(true);
        }
        return new ColumnFigure[]{nameLabel, typeLabel};
    }
}

