/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.widgets.Shell;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.sticky.StickyEditDialog;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractJmNodeEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.StickyDirectEditManager;
import org.jiemamy.eclipse.editor.figure.StickyFigure;
import org.jiemamy.eclipse.editor.tools.MultiLineTextCellEditor;
import org.jiemamy.eclipse.editor.tools.NodeCellEditorLocator;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.geometory.JmColor;
import org.jiemamy.model.geometory.JmRectangle;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.model.node.StickyModel;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class StickyEditPart
extends AbstractJmNodeEditPart {
    private static Logger logger = LoggerFactory.getLogger(StickyEditPart.class);

    public StickyEditPart(StickyModel stickyModel) {
        super((NodeAdapter)stickyModel);
    }

    public JiemamyElement getTargetModel() {
        StickyModel stickyModel = (StickyModel)this.getModel();
        return stickyModel;
    }

    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getParent().getModel();
        StickyModel stickyModel = (StickyModel)this.getModel();
        JiemamyViewFacade facade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        Shell shell = this.getViewer().getControl().getShell();
        StickyEditDialog dialog = new StickyEditDialog(shell, stickyModel, 0, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand((JiemamyFacade)facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    protected IFigure createFigure() {
        StickyFigure figure = new StickyFigure();
        String contents = ((StickyModel)this.getModel()).getContents();
        if (contents.length() > 0) {
            Panel tooltip = new Panel();
            tooltip.setLayoutManager((LayoutManager)new StackLayout());
            tooltip.setBackgroundColor(ColorConstants.tooltipBackground);
            tooltip.add((IFigure)new Label(contents));
            figure.setToolTip((IFigure)tooltip);
        }
        this.updateFigure((IFigure)figure);
        return figure;
    }

    protected DirectEditManager getDirectEditManager() {
        StickyFigure figure = (StickyFigure)this.getFigure();
        NodeCellEditorLocator locator = new NodeCellEditorLocator((IFigure)figure.getContentsLabel());
        return new StickyDirectEditManager((GraphicalEditPart)this, MultiLineTextCellEditor.class, locator);
    }

    protected void refreshVisuals() {
        GraphicalEditPart editPart = (GraphicalEditPart)this.getParent();
        if (editPart == null) {
            return;
        }
        RootModel rootModel = (RootModel)editPart.getModel();
        StickyModel stickyModel = (StickyModel)this.getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(stickyModel);
        if (nodeProfile != null) {
            JmRectangle boundary = nodeProfile.getBoundary();
            editPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)ConvertUtil.convert(boundary));
        }
        this.updateFigure(this.getFigure());
    }

    protected void updateFigure(IFigure figure) {
        RootModel rootModel = (RootModel)this.getParent().getModel();
        StickyModel stickyModel = (StickyModel)this.getModel();
        StickyFigure stickyFigure = (StickyFigure)figure;
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(stickyModel);
        if (nodeProfile == null) {
            return;
        }
        JmColor color = ((NodeProfile)presentation.getNodeProfiles().get(stickyModel)).getColor();
        stickyFigure.setContents(stickyModel.getContents());
        stickyFigure.setBgColor(ConvertUtil.convert(color));
    }
}

