/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.root.RootEditDialog;
import org.jiemamy.eclipse.editor.editpart.EditDialogSupport;
import org.jiemamy.eclipse.editor.editpolicy.JmLayoutEditPolicy;
import org.jiemamy.eclipse.preference.JiemamyPreference;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootEditPart
extends AbstractGraphicalEditPart
implements EditDialogSupport,
IPropertyChangeListener,
CommandListener {
    private static Logger logger = LoggerFactory.getLogger(RootEditPart.class);

    public RootEditPart(RootModel rootModel) {
        Validate.notNull((Object)rootModel);
        this.setModel(rootModel);
    }

    public void activate() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "activated");
        super.activate();
        IPreferenceStore ps = JiemamyUIPlugin.getDefault().getPreferenceStore();
        ps.addPropertyChangeListener((IPropertyChangeListener)this);
        RootModel rootModel = this.getModel();
        rootModel.getJiemamy().getEventBroker().addListener((CommandListener)this);
    }

    public void commandExecuted(org.jiemamy.editcommand.Command command) {
        this.refresh();
        this.refreshChildren();
    }

    public void deactivate() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "deactivate");
        RootModel rootModel = this.getModel();
        rootModel.getJiemamy().getEventBroker().removeListener((CommandListener)this);
        IPreferenceStore ps = JiemamyUIPlugin.getDefault().getPreferenceStore();
        ps.removePropertyChangeListener((IPropertyChangeListener)this);
        super.deactivate();
    }

    public RootModel getModel() {
        return (RootModel)super.getModel();
    }

    public JiemamyElement getTargetModel() {
        RootModel rootModel = this.getModel();
        return rootModel;
    }

    @Override
    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = this.getModel();
        JiemamyFacade facade = rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        RootEditDialog dialog = new RootEditDialog(this.getViewer().getControl().getShell(), rootModel, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand(facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    public void performRequest(Request req) {
        logger.info((Marker)LogMarker.LIFECYCLE, "Incoming GEF Request: " + req.getType());
        super.performRequest(req);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setConnectionRouter(this.getFigure());
    }

    public void setModel(Object model) {
        if (!(model instanceof RootModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new JmLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        Layer figure = new Layer();
        figure.setLayoutManager((LayoutManager)new XYLayout());
        this.setConnectionRouter((IFigure)figure);
        return figure;
    }

    protected List<NodeAdapter> getModelChildren() {
        RootModel rootModel = this.getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel diagramPresentationModel = diagramPresentations.get(0);
        return CollectionsUtil.newArrayList(diagramPresentationModel.getNodeProfiles().keySet());
    }

    private void setConnectionRouter(IFigure figure) {
        JiemamyPreference ps = JiemamyUIPlugin.getPreference();
        ConnectionRouter router = ps.getConnectionRouter().getRouter(figure);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(router);
    }
}

