/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.command.DialogEditCommand;
import org.jiemamy.eclipse.editor.dialog.foreignkey.ForeignKeyEditDialog;
import org.jiemamy.eclipse.editor.editpart.EditDialogSupport;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractJmConnectionEditPart;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ForeignKeyEditPart
extends AbstractJmConnectionEditPart
implements EditDialogSupport {
    private static Logger logger = LoggerFactory.getLogger(ForeignKeyEditPart.class);
    private Label label;

    public ForeignKeyEditPart(ConnectionAdapter connectionAdapter) {
        super(connectionAdapter);
        logger.debug((Marker)LogMarker.LIFECYCLE, "construct");
    }

    public JiemamyElement getTargetModel() {
        ConnectionAdapter connection = this.getModel();
        ForeignKey foreignKey = connection.unwrap();
        return foreignKey;
    }

    public void openEditDialog() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "openEditDialog");
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        ConnectionAdapter connection = this.getModel();
        ForeignKey foreignKey = connection.unwrap();
        JiemamyFacade facade = rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        SavePoint beforeEditSavePoint = facade.save();
        ForeignKeyEditDialog dialog = new ForeignKeyEditDialog(this.getViewer().getControl().getShell(), foreignKey, facade);
        if (dialog.open() == 0) {
            SavePoint afterEditSavePoint = facade.save();
            DialogEditCommand command = new DialogEditCommand(facade, beforeEditSavePoint, afterEditSavePoint);
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        } else {
            facade.rollback(beforeEditSavePoint);
        }
    }

    public void performRequest(Request req) {
        logger.info((Marker)LogMarker.LIFECYCLE, "Incoming GEF Request: " + req.getType());
        if (req.getType().equals("open")) {
            this.openEditDialog();
            return;
        }
        super.performRequest(req);
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        this.updateLabel();
    }

    protected IFigure createFigure() {
        PolylineConnection connection = new PolylineConnection();
        connection.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        this.label = new Label();
        this.label.setLabelAlignment(2);
        this.label.setOpaque(true);
        this.label.setBackgroundColor(Display.getDefault().getSystemColor(1));
        this.updateLabel();
        connection.add((IFigure)this.label, (Object)new ConnectionLocator((Connection)connection, 4));
        return connection;
    }

    private void updateLabel() {
        if (this.getParent() == null) {
            return;
        }
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        ConnectionAdapter connection = this.getModel();
        ForeignKey foreignKey = connection.unwrap();
        String labelString = LabelStringUtil.getString(rootModel, (JiemamyElement)foreignKey, DisplayPlace.FIGURE);
        this.label.setText(labelString);
    }
}

