/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.ListUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.jiemamy.eclipse.editor.editpart.EditDialogSupport;
import org.jiemamy.eclipse.editor.editpolicy.JmComponentEditPolicy;
import org.jiemamy.eclipse.editor.editpolicy.JmDirectEditPolicy;
import org.jiemamy.eclipse.editor.editpolicy.JmGraphicalNodeEditPolicy;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJmNodeEditPart
extends AbstractGraphicalEditPart
implements EditDialogSupport,
NodeEditPart,
CommandListener {
    private static Logger logger = LoggerFactory.getLogger(AbstractJmNodeEditPart.class);
    private DirectEditManager directManager = null;

    public AbstractJmNodeEditPart(NodeAdapter nodeAdapter) {
        Validate.notNull((Object)nodeAdapter);
        this.setModel(nodeAdapter);
    }

    public void activate() {
        super.activate();
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        rootModel.getJiemamy().getEventBroker().addListener((CommandListener)this);
        logger.debug("activate");
    }

    public void commandExecuted(Command command) {
        this.refresh();
        this.refreshVisuals();
    }

    public void deactivate() {
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        rootModel.getJiemamy().getEventBroker().removeListener((CommandListener)this);
        super.deactivate();
        logger.debug("deactivate");
    }

    public Object getAdapter(Class key) {
        EntityModel entityModel;
        logger.debug(key.getName());
        NodeAdapter nodeAdapter = this.getModel();
        if (nodeAdapter.unwrap() != null && (entityModel = nodeAdapter.unwrap()).hasAdapter(key)) {
            return entityModel.getAdapter(key);
        }
        return super.getAdapter(key);
    }

    public NodeAdapter getModel() {
        return (NodeAdapter)super.getModel();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public void performRequest(Request req) {
        logger.info((Marker)LogMarker.LIFECYCLE, "Incoming GEF Request: " + req.getType());
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        if (req.getType().equals("open")) {
            this.openEditDialog();
            return;
        }
        super.performRequest(req);
    }

    public void setModel(Object model) {
        if (!(model instanceof NodeAdapter)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new JmComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new JmGraphicalNodeEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new JmDirectEditPolicy());
    }

    protected abstract DirectEditManager getDirectEditManager();

    protected List<ConnectionAdapter> getModelSourceConnections() {
        if (this.getParent() == null) {
            List result = ListUtils.EMPTY_LIST;
            return result;
        }
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel diagramPresentationModel = diagramPresentations.get(0);
        Map connectionProfiles = diagramPresentationModel.getConnectionProfiles();
        ArrayList result = CollectionsUtil.newArrayList();
        Collection connections = this.getModel().getSourceConnections();
        for (ConnectionAdapter connectionAdapter : connections) {
            if (!connectionProfiles.containsKey(connectionAdapter)) continue;
            result.add(connectionAdapter);
        }
        logger.debug(this.getModel() + " sourceConnections = " + result);
        return result;
    }

    protected List<ConnectionAdapter> getModelTargetConnections() {
        if (this.getParent() == null) {
            List result = ListUtils.EMPTY_LIST;
            return result;
        }
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel diagramPresentationModel = diagramPresentations.get(0);
        Map connectionProfiles = diagramPresentationModel.getConnectionProfiles();
        ArrayList result = CollectionsUtil.newArrayList();
        Collection connections = this.getModel().getTargetConnections();
        for (ConnectionAdapter connectionAdapter : connections) {
            if (!connectionProfiles.containsKey(connectionAdapter)) continue;
            result.add(connectionAdapter);
        }
        logger.debug(this.getModel() + " targetConnections = " + result);
        return result;
    }

    protected abstract void updateFigure(IFigure var1);

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = this.getDirectEditManager();
        }
        this.directManager.show();
    }
}

