/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.jiemamy.eclipse.editor.editpolicy.JmBendpointEditPolicy;
import org.jiemamy.eclipse.editor.editpolicy.JmConnectionEditPolicy;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.model.ConnectionProfile;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmConnectionEditPart
extends AbstractConnectionEditPart
implements CommandListener {
    private static Logger logger = LoggerFactory.getLogger(AbstractJmConnectionEditPart.class);

    public AbstractJmConnectionEditPart(ConnectionAdapter connectionAdapter) {
        Validate.notNull((Object)connectionAdapter);
        this.setModel(connectionAdapter);
    }

    public void activate() {
        super.activate();
        ConnectionAdapter model = this.getModel();
        model.unwrap().getJiemamy().getEventBroker().addListener((CommandListener)this);
        logger.debug("activate");
    }

    public void commandExecuted(Command command) {
        this.refreshVisuals();
    }

    public void deactivate() {
        ConnectionAdapter model = this.getModel();
        model.unwrap().getJiemamy().getEventBroker().removeListener((CommandListener)this);
        super.deactivate();
        logger.debug("deactivate");
    }

    public ConnectionAdapter getModel() {
        return (ConnectionAdapter)super.getModel();
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBendpoints();
    }

    public void setModel(Object model) {
        if (!(model instanceof ConnectionAdapter)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new JmConnectionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new JmBendpointEditPolicy());
    }

    private void refreshBendpoints() {
        if (this.getParent() == null) {
            return;
        }
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel diagramPresentationModel = diagramPresentations.get(0);
        Map connectionProfiles = diagramPresentationModel.getConnectionProfiles();
        ConnectionAdapter connection = this.getModel();
        ConnectionProfile connectionProfile = (ConnectionProfile)diagramPresentationModel.getConnectionProfiles().get(connection);
        if (connectionProfile == null) {
            return;
        }
        List bendpoints = connectionProfile.getBendpoints();
        if (!connectionProfiles.containsKey(connection)) {
            bendpoints.clear();
        }
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>(bendpoints.size());
        for (JmPoint bendpoint : bendpoints) {
            constraint.add(new AbsoluteBendpoint(new Point(bendpoint.x, bendpoint.y)));
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }
}

