/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart.diagram;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractJmNodeEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.EntityDirectEditManager;
import org.jiemamy.eclipse.editor.figure.EntityFigure;
import org.jiemamy.eclipse.editor.tools.NodeCellEditorLocator;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.geometory.JmRectangle;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public abstract class AbstractEntityNodeEditPart
extends AbstractJmNodeEditPart {
    private static Logger logger = LoggerFactory.getLogger(AbstractEntityNodeEditPart.class);

    public AbstractEntityNodeEditPart(NodeAdapter nodeAdapter) {
        super(nodeAdapter);
    }

    public JiemamyElement getTargetModel() {
        NodeAdapter node = this.getModel();
        EntityModel entityModel = node.unwrap();
        return entityModel;
    }

    protected DirectEditManager getDirectEditManager() {
        EntityFigure figure = (EntityFigure)this.getFigure();
        NodeCellEditorLocator locator = new NodeCellEditorLocator((IFigure)figure.getEntityNameLabel());
        return new EntityDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, locator);
    }

    protected void refreshVisuals() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "refreshVisuals");
        super.refreshVisuals();
        GraphicalEditPart editPart = (GraphicalEditPart)this.getParent();
        if (editPart == null) {
            return;
        }
        RootModel rootModel = (RootModel)this.getRoot().getContents().getModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(0);
        NodeAdapter node = this.getModel();
        NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(node);
        if (nodeProfile != null) {
            JmRectangle boundary = nodeProfile.getBoundary();
            editPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)ConvertUtil.convert(boundary));
        }
        this.updateFigure(this.getFigure());
    }
}

