/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.editpart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.editpart.EditDialogSupport;
import org.jiemamy.eclipse.editor.editpart.diagram.ForeignKeyEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.RootEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.StickyEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.TableEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.ViewEditPart;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.model.node.StickyModel;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class DiagramEditPartFactory
implements EditPartFactory {
    private static Logger logger = LoggerFactory.getLogger(DiagramEditPartFactory.class);

    public EditPart createEditPart(EditPart context, Object model) {
        logger.debug((Marker)LogMarker.LIFECYCLE, "createEditPart for " + model);
        EditDialogSupport part = null;
        if (model instanceof RootModel) {
            part = new RootEditPart((RootModel)model);
        } else if (model instanceof NodeAdapter) {
            NodeAdapter nodeAdapter = (NodeAdapter)model;
            EntityModel entityModel = nodeAdapter.unwrap();
            if (entityModel instanceof TableModel) {
                part = new TableEditPart((NodeAdapter)model);
            } else if (entityModel instanceof ViewModel) {
                part = new ViewEditPart((NodeAdapter)model);
            } else if (entityModel == null) {
                if (nodeAdapter instanceof StickyModel) {
                    part = new StickyEditPart((StickyModel)nodeAdapter);
                } else {
                    JiemamyUIPlugin.log("unknown node: " + model.getClass().getName(), 4);
                }
            } else {
                JiemamyUIPlugin.log("unknown entity: " + model.getClass().getName(), 4);
            }
        } else if (model instanceof ConnectionAdapter) {
            ConnectionAdapter connectionAdapter = (ConnectionAdapter)model;
            ForeignKey foreignKey = connectionAdapter.unwrap();
            if (foreignKey != null) {
                part = new ForeignKeyEditPart(connectionAdapter);
            } else {
                JiemamyUIPlugin.log("unknown connection: " + model.getClass().getName(), 4);
            }
        } else {
            JiemamyUIPlugin.log("unknown model: " + model.getClass().getName(), 4);
        }
        if (part == null) {
            JiemamyUIPlugin.log("Cannot create EditPart for unknown model.", 4);
        }
        return part;
    }
}

